// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworkscm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteServerInput struct {
	_ struct{} `type:"structure"`

	// The ID of the server to delete.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteServerInput"}

	if s.ServerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteServer = "DeleteServer"

// DeleteServerRequest returns a request value for making API operation for
// AWS OpsWorks CM.
//
// Deletes the server and the underlying AWS CloudFormation stacks (including
// the server's EC2 instance). When you run this command, the server state is
// updated to DELETING. After the server is deleted, it is no longer returned
// by DescribeServer requests. If the AWS CloudFormation stack cannot be deleted,
// the server cannot be deleted.
//
// This operation is asynchronous.
//
// An InvalidStateException is thrown when a server deletion is already in progress.
// A ResourceNotFoundException is thrown when the server does not exist. A ValidationException
// is raised when parameters of the request are not valid.
//
//    // Example sending a request using DeleteServerRequest.
//    req := client.DeleteServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DeleteServer
func (c *Client) DeleteServerRequest(input *DeleteServerInput) DeleteServerRequest {
	op := &aws.Operation{
		Name:       opDeleteServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServerInput{}
	}

	req := c.newRequest(op, input, &DeleteServerOutput{})

	return DeleteServerRequest{Request: req, Input: input, Copy: c.DeleteServerRequest}
}

// DeleteServerRequest is the request type for the
// DeleteServer API operation.
type DeleteServerRequest struct {
	*aws.Request
	Input *DeleteServerInput
	Copy  func(*DeleteServerInput) DeleteServerRequest
}

// Send marshals and sends the DeleteServer API request.
func (r DeleteServerRequest) Send(ctx context.Context) (*DeleteServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteServerResponse{
		DeleteServerOutput: r.Request.Data.(*DeleteServerOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteServerResponse is the response type for the
// DeleteServer API operation.
type DeleteServerResponse struct {
	*DeleteServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteServer request.
func (r *DeleteServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
