// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateLinkInput struct {
	_ struct{} `type:"structure"`

	// The upload and download speed in Mbps.
	Bandwidth *Bandwidth `type:"structure"`

	// A description of the link.
	//
	// Length Constraints: Maximum length of 256 characters.
	Description *string `type:"string"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The ID of the link.
	//
	// LinkId is a required field
	LinkId *string `location:"uri" locationName:"linkId" type:"string" required:"true"`

	// The provider of the link.
	//
	// Length Constraints: Maximum length of 128 characters.
	Provider *string `type:"string"`

	// The type of the link.
	//
	// Length Constraints: Maximum length of 128 characters.
	Type *string `type:"string"`
}

// String returns the string representation
func (s UpdateLinkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLinkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateLinkInput"}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if s.LinkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LinkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateLinkInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Bandwidth != nil {
		v := s.Bandwidth

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Bandwidth", v, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Provider != nil {
		v := *s.Provider

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Provider", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkId != nil {
		v := *s.LinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "linkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateLinkOutput struct {
	_ struct{} `type:"structure"`

	// Information about the link.
	Link *Link `type:"structure"`
}

// String returns the string representation
func (s UpdateLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateLinkOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Link != nil {
		v := s.Link

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Link", v, metadata)
	}
	return nil
}

const opUpdateLink = "UpdateLink"

// UpdateLinkRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Updates the details for an existing link. To remove information for any of
// the parameters, specify an empty string.
//
//    // Example sending a request using UpdateLinkRequest.
//    req := client.UpdateLinkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateLink
func (c *Client) UpdateLinkRequest(input *UpdateLinkInput) UpdateLinkRequest {
	op := &aws.Operation{
		Name:       opUpdateLink,
		HTTPMethod: "PATCH",
		HTTPPath:   "/global-networks/{globalNetworkId}/links/{linkId}",
	}

	if input == nil {
		input = &UpdateLinkInput{}
	}

	req := c.newRequest(op, input, &UpdateLinkOutput{})

	return UpdateLinkRequest{Request: req, Input: input, Copy: c.UpdateLinkRequest}
}

// UpdateLinkRequest is the request type for the
// UpdateLink API operation.
type UpdateLinkRequest struct {
	*aws.Request
	Input *UpdateLinkInput
	Copy  func(*UpdateLinkInput) UpdateLinkRequest
}

// Send marshals and sends the UpdateLink API request.
func (r UpdateLinkRequest) Send(ctx context.Context) (*UpdateLinkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateLinkResponse{
		UpdateLinkOutput: r.Request.Data.(*UpdateLinkOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateLinkResponse is the response type for the
// UpdateLink API operation.
type UpdateLinkResponse struct {
	*UpdateLinkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateLink request.
func (r *UpdateLinkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
