// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateGlobalNetworkInput struct {
	_ struct{} `type:"structure"`

	// A description of the global network.
	//
	// Length Constraints: Maximum length of 256 characters.
	Description *string `type:"string"`

	// The ID of your global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGlobalNetworkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGlobalNetworkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGlobalNetworkInput"}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGlobalNetworkInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateGlobalNetworkOutput struct {
	_ struct{} `type:"structure"`

	// Information about the global network object.
	GlobalNetwork *GlobalNetwork `type:"structure"`
}

// String returns the string representation
func (s UpdateGlobalNetworkOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGlobalNetworkOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GlobalNetwork != nil {
		v := s.GlobalNetwork

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GlobalNetwork", v, metadata)
	}
	return nil
}

const opUpdateGlobalNetwork = "UpdateGlobalNetwork"

// UpdateGlobalNetworkRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Updates an existing global network. To remove information for any of the
// parameters, specify an empty string.
//
//    // Example sending a request using UpdateGlobalNetworkRequest.
//    req := client.UpdateGlobalNetworkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/UpdateGlobalNetwork
func (c *Client) UpdateGlobalNetworkRequest(input *UpdateGlobalNetworkInput) UpdateGlobalNetworkRequest {
	op := &aws.Operation{
		Name:       opUpdateGlobalNetwork,
		HTTPMethod: "PATCH",
		HTTPPath:   "/global-networks/{globalNetworkId}",
	}

	if input == nil {
		input = &UpdateGlobalNetworkInput{}
	}

	req := c.newRequest(op, input, &UpdateGlobalNetworkOutput{})

	return UpdateGlobalNetworkRequest{Request: req, Input: input, Copy: c.UpdateGlobalNetworkRequest}
}

// UpdateGlobalNetworkRequest is the request type for the
// UpdateGlobalNetwork API operation.
type UpdateGlobalNetworkRequest struct {
	*aws.Request
	Input *UpdateGlobalNetworkInput
	Copy  func(*UpdateGlobalNetworkInput) UpdateGlobalNetworkRequest
}

// Send marshals and sends the UpdateGlobalNetwork API request.
func (r UpdateGlobalNetworkRequest) Send(ctx context.Context) (*UpdateGlobalNetworkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGlobalNetworkResponse{
		UpdateGlobalNetworkOutput: r.Request.Data.(*UpdateGlobalNetworkOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGlobalNetworkResponse is the response type for the
// UpdateGlobalNetwork API operation.
type UpdateGlobalNetworkResponse struct {
	*UpdateGlobalNetworkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGlobalNetwork request.
func (r *UpdateGlobalNetworkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
