// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediastore

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutMetricPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that you want to add the metric policy to.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`

	// The metric policy that you want to associate with the container. In the policy,
	// you must indicate whether you want MediaStore to send container-level metrics.
	// You can also include up to five rules to define groups of objects that you
	// want MediaStore to send object-level metrics for. If you include rules in
	// the policy, construct each rule with both of the following:
	//
	//    * An object group that defines which objects to include in the group.
	//    The definition can be a path or a file name, but it can't have more than
	//    900 characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), =
	//    (equal), : (colon), . (period), - (hyphen), ~ (tilde), / (forward slash),
	//    and * (asterisk). Wildcards (*) are acceptable.
	//
	//    * An object group name that allows you to refer to the object group. The
	//    name can't have more than 30 characters. Valid characters are: a-z, A-Z,
	//    0-9, and _ (underscore).
	//
	// MetricPolicy is a required field
	MetricPolicy *MetricPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutMetricPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetricPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutMetricPolicyInput"}

	if s.ContainerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContainerName", 1))
	}

	if s.MetricPolicy == nil {
		invalidParams.Add(aws.NewErrParamRequired("MetricPolicy"))
	}
	if s.MetricPolicy != nil {
		if err := s.MetricPolicy.Validate(); err != nil {
			invalidParams.AddNested("MetricPolicy", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutMetricPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMetricPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutMetricPolicy = "PutMetricPolicy"

// PutMetricPolicyRequest returns a request value for making API operation for
// AWS Elemental MediaStore.
//
// The metric policy that you want to add to the container. A metric policy
// allows AWS Elemental MediaStore to send metrics to Amazon CloudWatch. It
// takes up to 20 minutes for the new policy to take effect.
//
//    // Example sending a request using PutMetricPolicyRequest.
//    req := client.PutMetricPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutMetricPolicy
func (c *Client) PutMetricPolicyRequest(input *PutMetricPolicyInput) PutMetricPolicyRequest {
	op := &aws.Operation{
		Name:       opPutMetricPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutMetricPolicyInput{}
	}

	req := c.newRequest(op, input, &PutMetricPolicyOutput{})

	return PutMetricPolicyRequest{Request: req, Input: input, Copy: c.PutMetricPolicyRequest}
}

// PutMetricPolicyRequest is the request type for the
// PutMetricPolicy API operation.
type PutMetricPolicyRequest struct {
	*aws.Request
	Input *PutMetricPolicyInput
	Copy  func(*PutMetricPolicyInput) PutMetricPolicyRequest
}

// Send marshals and sends the PutMetricPolicy API request.
func (r PutMetricPolicyRequest) Send(ctx context.Context) (*PutMetricPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutMetricPolicyResponse{
		PutMetricPolicyOutput: r.Request.Data.(*PutMetricPolicyOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutMetricPolicyResponse is the response type for the
// PutMetricPolicy API operation.
type PutMetricPolicyResponse struct {
	*PutMetricPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutMetricPolicy request.
func (r *PutMetricPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
