// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplacecatalog

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// An object that contains the ChangeType, Details, and Entity.
type Change struct {
	_ struct{} `type:"structure"`

	// Change types are single string values that describe your intention for the
	// change. Each change type is unique for each EntityType provided in the change's
	// scope.
	//
	// ChangeType is a required field
	ChangeType *string `min:"1" type:"string" required:"true"`

	// This object contains details specific to the change type of the requested
	// change.
	//
	// Details is a required field
	Details *string `min:"2" type:"string" required:"true"`

	// The entity to be changed.
	//
	// Entity is a required field
	Entity *Entity `type:"structure" required:"true"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Change) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Change"}

	if s.ChangeType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeType"))
	}
	if s.ChangeType != nil && len(*s.ChangeType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeType", 1))
	}

	if s.Details == nil {
		invalidParams.Add(aws.NewErrParamRequired("Details"))
	}
	if s.Details != nil && len(*s.Details) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Details", 2))
	}

	if s.Entity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Entity"))
	}
	if s.Entity != nil {
		if err := s.Entity.Validate(); err != nil {
			invalidParams.AddNested("Entity", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Change) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChangeType != nil {
		v := *s.ChangeType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Details != nil {
		v := *s.Details

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Details", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Entity != nil {
		v := s.Entity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Entity", v, metadata)
	}
	return nil
}

// A summary of a change set returned in a list of change sets when the ListChangeSets
// action is called.
type ChangeSetSummaryListItem struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the unique identifier for the change set referenced
	// in this request.
	ChangeSetArn *string `min:"1" type:"string"`

	// The unique identifier for a change set.
	ChangeSetId *string `min:"1" type:"string"`

	// The non-unique name for the change set.
	ChangeSetName *string `min:"1" type:"string"`

	// The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set
	// was finished.
	EndTime *string `min:"20" type:"string"`

	// This object is a list of entity IDs (string) that are a part of a change
	// set. The entity ID list is a maximum of 20 entities. It must contain at least
	// one entity.
	EntityIdList []string `type:"list"`

	// The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set
	// was started.
	StartTime *string `min:"20" type:"string"`

	// The current status of the change set.
	Status ChangeStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ChangeSetSummaryListItem) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChangeSetSummaryListItem) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChangeSetArn != nil {
		v := *s.ChangeSetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeSetId != nil {
		v := *s.ChangeSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeSetName != nil {
		v := *s.ChangeSetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeSetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntityIdList != nil {
		v := s.EntityIdList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "EntityIdList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// This object is a container for common summary information about the change.
// The summary doesn't contain the whole change structure.
type ChangeSummary struct {
	_ struct{} `type:"structure"`

	// The type of the change.
	ChangeType *string `min:"1" type:"string"`

	// This object contains details specific to the change type of the requested
	// change.
	Details *string `min:"2" type:"string"`

	// The entity to be changed.
	Entity *Entity `type:"structure"`

	// An array of ErrorDetail objects associated with the change.
	ErrorDetailList []ErrorDetail `type:"list"`
}

// String returns the string representation
func (s ChangeSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChangeSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChangeType != nil {
		v := *s.ChangeType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ChangeType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Details != nil {
		v := *s.Details

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Details", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Entity != nil {
		v := s.Entity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Entity", v, metadata)
	}
	if s.ErrorDetailList != nil {
		v := s.ErrorDetailList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ErrorDetailList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A product entity contains data that describes your product, its supported
// features, and how it can be used or launched by your customer.
type Entity struct {
	_ struct{} `type:"structure"`

	// The identifier for the entity.
	Identifier *string `min:"1" type:"string"`

	// The type of entity.
	//
	// Type is a required field
	Type *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Entity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Entity"}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Identifier", 1))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(*s.Type) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Entity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Identifier != nil {
		v := *s.Identifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Identifier", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// This object is a container for common summary information about the entity.
// The summary doesn't contain the whole entity structure, but it does contain
// information common across all entities.
type EntitySummary struct {
	_ struct{} `type:"structure"`

	// The ARN associated with the unique identifier for the entity.
	EntityArn *string `min:"1" type:"string"`

	// The unique identifier for the entity.
	EntityId *string `min:"1" type:"string"`

	// The type of the entity.
	EntityType *string `min:"1" type:"string"`

	// The last time the entity was published, using ISO 8601 format (2018-02-27T13:45:22Z).
	LastModifiedDate *string `type:"string"`

	// The name for the entity. This value is not unique. It is defined by the seller.
	Name *string `type:"string"`

	// The visibility status of the entity to buyers. This value can be Public (everyone
	// can view the entity), Limited (the entity is visible to limited accounts
	// only), or Restricted (the entity was published and then unpublished and only
	// existing buyers can view it).
	Visibility *string `type:"string"`
}

// String returns the string representation
func (s EntitySummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EntitySummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.EntityArn != nil {
		v := *s.EntityArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EntityArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntityId != nil {
		v := *s.EntityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EntityId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntityType != nil {
		v := *s.EntityType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EntityType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastModifiedDate != nil {
		v := *s.LastModifiedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastModifiedDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Visibility != nil {
		v := *s.Visibility

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Visibility", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details about the error.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// The error code that identifies the type of error.
	ErrorCode *string `type:"string"`

	// The message for the error.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A filter object, used to optionally filter results from calls to the ListEntities
// and ListChangeSets actions.
type Filter struct {
	_ struct{} `type:"structure"`

	// For ListEntities, the supported value for this is an EntityId.
	//
	// For ListChangeSets, the supported values are as follows:
	Name *string `min:"1" type:"string"`

	// ListEntities - This is a list of unique EntityIds.
	//
	// ListChangeSets - The supported filter names and associated ValueLists is
	// as follows:
	//
	//    * ChangeSetName - The supported ValueList is a list of non-unique ChangeSetNames.
	//    These are defined when you call the StartChangeSet action.
	//
	//    * Status - The supported ValueList is a list of statuses for all change
	//    set requests.
	//
	//    * EntityId - The supported ValueList is a list of unique EntityIds.
	//
	//    * BeforeStartTime - The supported ValueList is a list of all change sets
	//    that started before the filter value.
	//
	//    * AfterStartTime - The supported ValueList is a list of all change sets
	//    that started after the filter value.
	//
	//    * BeforeEndTime - The supported ValueList is a list of all change sets
	//    that ended before the filter value.
	//
	//    * AfterEndTime - The supported ValueList is a list of all change sets
	//    that ended after the filter value.
	ValueList []string `min:"1" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.ValueList != nil && len(s.ValueList) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ValueList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Filter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ValueList != nil {
		v := s.ValueList

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ValueList", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An object that contains two attributes, SortBy and SortOrder.
type Sort struct {
	_ struct{} `type:"structure"`

	// For ListEntities, supported attributes include LastModifiedDate (default),
	// Visibility, EntityId, and Name.
	//
	// For ListChangeSets, supported attributes include StartTime and EndTime.
	SortBy *string `min:"1" type:"string"`

	// The sorting order. Can be ASCENDING or DESCENDING. The default value is DESCENDING.
	SortOrder SortOrder `type:"string" enum:"true"`
}

// String returns the string representation
func (s Sort) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Sort) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Sort"}
	if s.SortBy != nil && len(*s.SortBy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SortBy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Sort) MarshalFields(e protocol.FieldEncoder) error {
	if s.SortBy != nil {
		v := *s.SortBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SortBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SortOrder) > 0 {
		v := s.SortOrder

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SortOrder", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}
