// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies one or more findings to retrieve information about.
type GetFindingsInput struct {
	_ struct{} `type:"structure"`

	// FindingIds is a required field
	FindingIds []string `locationName:"findingIds" type:"list" required:"true"`

	// Specifies criteria for sorting the results of a request for information about
	// findings.
	SortCriteria *SortCriteria `locationName:"sortCriteria" type:"structure"`
}

// String returns the string representation
func (s GetFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFindingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFindingsInput"}

	if s.FindingIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("FindingIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFindingsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FindingIds != nil {
		v := s.FindingIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "findingIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SortCriteria != nil {
		v := s.SortCriteria

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "sortCriteria", v, metadata)
	}
	return nil
}

// Provides the results of a request for information about one or more findings.
type GetFindingsOutput struct {
	_ struct{} `type:"structure"`

	Findings []Finding `locationName:"findings" type:"list"`
}

// String returns the string representation
func (s GetFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFindingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Findings != nil {
		v := s.Findings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "findings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetFindings = "GetFindings"

// GetFindingsRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Retrieves information about one or more findings.
//
//    // Example sending a request using GetFindingsRequest.
//    req := client.GetFindingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/GetFindings
func (c *Client) GetFindingsRequest(input *GetFindingsInput) GetFindingsRequest {
	op := &aws.Operation{
		Name:       opGetFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/findings/describe",
	}

	if input == nil {
		input = &GetFindingsInput{}
	}

	req := c.newRequest(op, input, &GetFindingsOutput{})

	return GetFindingsRequest{Request: req, Input: input, Copy: c.GetFindingsRequest}
}

// GetFindingsRequest is the request type for the
// GetFindings API operation.
type GetFindingsRequest struct {
	*aws.Request
	Input *GetFindingsInput
	Copy  func(*GetFindingsInput) GetFindingsRequest
}

// Send marshals and sends the GetFindings API request.
func (r GetFindingsRequest) Send(ctx context.Context) (*GetFindingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetFindingsResponse{
		GetFindingsOutput: r.Request.Data.(*GetFindingsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetFindingsResponse is the response type for the
// GetFindings API operation.
type GetFindingsResponse struct {
	*GetFindingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetFindings request.
func (r *GetFindingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
