// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Enables Amazon Macie and specifies the configuration settings for an Amazon
// Macie account.
type EnableMacieInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The frequency with which Amazon Macie publishes updates to policy findings
	// for an account. This includes publishing updates to AWS Security Hub and
	// Amazon EventBridge (formerly called Amazon CloudWatch Events). Valid values
	// are:
	FindingPublishingFrequency FindingPublishingFrequency `locationName:"findingPublishingFrequency" type:"string" enum:"true"`

	// The status of an Amazon Macie account. Valid values are:
	Status MacieStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s EnableMacieInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnableMacieInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.FindingPublishingFrequency) > 0 {
		v := s.FindingPublishingFrequency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "findingPublishingFrequency", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type EnableMacieOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableMacieOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EnableMacieOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opEnableMacie = "EnableMacie"

// EnableMacieRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Enables Amazon Macie and specifies the configuration settings for a Macie
// account.
//
//    // Example sending a request using EnableMacieRequest.
//    req := client.EnableMacieRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/EnableMacie
func (c *Client) EnableMacieRequest(input *EnableMacieInput) EnableMacieRequest {
	op := &aws.Operation{
		Name:       opEnableMacie,
		HTTPMethod: "POST",
		HTTPPath:   "/macie",
	}

	if input == nil {
		input = &EnableMacieInput{}
	}

	req := c.newRequest(op, input, &EnableMacieOutput{})

	return EnableMacieRequest{Request: req, Input: input, Copy: c.EnableMacieRequest}
}

// EnableMacieRequest is the request type for the
// EnableMacie API operation.
type EnableMacieRequest struct {
	*aws.Request
	Input *EnableMacieInput
	Copy  func(*EnableMacieInput) EnableMacieRequest
}

// Send marshals and sends the EnableMacie API request.
func (r EnableMacieRequest) Send(ctx context.Context) (*EnableMacieResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableMacieResponse{
		EnableMacieOutput: r.Request.Data.(*EnableMacieOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableMacieResponse is the response type for the
// EnableMacie API operation.
type EnableMacieResponse struct {
	*EnableMacieOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableMacie request.
func (r *EnableMacieResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
