// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies the settings for an Amazon Macie membership invitation.
type CreateInvitationsInput struct {
	_ struct{} `type:"structure"`

	// AccountIds is a required field
	AccountIds []string `locationName:"accountIds" type:"list" required:"true"`

	DisableEmailNotification *bool `locationName:"disableEmailNotification" type:"boolean"`

	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s CreateInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInvitationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateInvitationsInput"}

	if s.AccountIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateInvitationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountIds != nil {
		v := s.AccountIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "accountIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.DisableEmailNotification != nil {
		v := *s.DisableEmailNotification

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "disableEmailNotification", protocol.BoolValue(v), metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides information about an unprocessed request to send an Amazon Macie
// membership invitation to a specific account.
type CreateInvitationsOutput struct {
	_ struct{} `type:"structure"`

	UnprocessedAccounts []UnprocessedAccount `locationName:"unprocessedAccounts" type:"list"`
}

// String returns the string representation
func (s CreateInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateInvitationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.UnprocessedAccounts != nil {
		v := s.UnprocessedAccounts

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "unprocessedAccounts", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opCreateInvitations = "CreateInvitations"

// CreateInvitationsRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Sends an Amazon Macie membership invitation to one or more accounts.
//
//    // Example sending a request using CreateInvitationsRequest.
//    req := client.CreateInvitationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateInvitations
func (c *Client) CreateInvitationsRequest(input *CreateInvitationsInput) CreateInvitationsRequest {
	op := &aws.Operation{
		Name:       opCreateInvitations,
		HTTPMethod: "POST",
		HTTPPath:   "/invitations",
	}

	if input == nil {
		input = &CreateInvitationsInput{}
	}

	req := c.newRequest(op, input, &CreateInvitationsOutput{})

	return CreateInvitationsRequest{Request: req, Input: input, Copy: c.CreateInvitationsRequest}
}

// CreateInvitationsRequest is the request type for the
// CreateInvitations API operation.
type CreateInvitationsRequest struct {
	*aws.Request
	Input *CreateInvitationsInput
	Copy  func(*CreateInvitationsInput) CreateInvitationsRequest
}

// Send marshals and sends the CreateInvitations API request.
func (r CreateInvitationsRequest) Send(ctx context.Context) (*CreateInvitationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateInvitationsResponse{
		CreateInvitationsOutput: r.Request.Data.(*CreateInvitationsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateInvitationsResponse is the response type for the
// CreateInvitations API operation.
type CreateInvitationsResponse struct {
	*CreateInvitationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateInvitations request.
func (r *CreateInvitationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
