// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Specifies the criteria and other settings for a new custom data identifier.
// You can't change a custom data identifier after you create it. In Amazon
// Macie, custom data identifiers are immutable. This ensures accurate data
// classification results for audits or investigations.
type CreateCustomDataIdentifierInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	Description *string `locationName:"description" type:"string"`

	IgnoreWords []string `locationName:"ignoreWords" type:"list"`

	Keywords []string `locationName:"keywords" type:"list"`

	MaximumMatchDistance *int64 `locationName:"maximumMatchDistance" type:"integer"`

	Name *string `locationName:"name" type:"string"`

	Regex *string `locationName:"regex" type:"string"`

	// A string-to-string map of key-value pairs that specifies the tags (keys and
	// values) for a classification job, custom data identifier, findings filter,
	// or member account.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateCustomDataIdentifierInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCustomDataIdentifierInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IgnoreWords != nil {
		v := s.IgnoreWords

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ignoreWords", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Keywords != nil {
		v := s.Keywords

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "keywords", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MaximumMatchDistance != nil {
		v := *s.MaximumMatchDistance

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maximumMatchDistance", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Regex != nil {
		v := *s.Regex

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "regex", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Provides information about a custom data identifier that was created in response
// to a request.
type CreateCustomDataIdentifierOutput struct {
	_ struct{} `type:"structure"`

	CustomDataIdentifierId *string `locationName:"customDataIdentifierId" type:"string"`
}

// String returns the string representation
func (s CreateCustomDataIdentifierOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateCustomDataIdentifierOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomDataIdentifierId != nil {
		v := *s.CustomDataIdentifierId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "customDataIdentifierId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateCustomDataIdentifier = "CreateCustomDataIdentifier"

// CreateCustomDataIdentifierRequest returns a request value for making API operation for
// Amazon Macie 2.
//
// Creates and defines the criteria and other settings for a custom data identifier.
//
//    // Example sending a request using CreateCustomDataIdentifierRequest.
//    req := client.CreateCustomDataIdentifierRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/CreateCustomDataIdentifier
func (c *Client) CreateCustomDataIdentifierRequest(input *CreateCustomDataIdentifierInput) CreateCustomDataIdentifierRequest {
	op := &aws.Operation{
		Name:       opCreateCustomDataIdentifier,
		HTTPMethod: "POST",
		HTTPPath:   "/custom-data-identifiers",
	}

	if input == nil {
		input = &CreateCustomDataIdentifierInput{}
	}

	req := c.newRequest(op, input, &CreateCustomDataIdentifierOutput{})

	return CreateCustomDataIdentifierRequest{Request: req, Input: input, Copy: c.CreateCustomDataIdentifierRequest}
}

// CreateCustomDataIdentifierRequest is the request type for the
// CreateCustomDataIdentifier API operation.
type CreateCustomDataIdentifierRequest struct {
	*aws.Request
	Input *CreateCustomDataIdentifierInput
	Copy  func(*CreateCustomDataIdentifierInput) CreateCustomDataIdentifierRequest
}

// Send marshals and sends the CreateCustomDataIdentifier API request.
func (r CreateCustomDataIdentifierRequest) Send(ctx context.Context) (*CreateCustomDataIdentifierResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCustomDataIdentifierResponse{
		CreateCustomDataIdentifierOutput: r.Request.Data.(*CreateCustomDataIdentifierOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCustomDataIdentifierResponse is the response type for the
// CreateCustomDataIdentifier API operation.
type CreateCustomDataIdentifierResponse struct {
	*CreateCustomDataIdentifierOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCustomDataIdentifier request.
func (r *CreateCustomDataIdentifierResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
