// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DisassociateMemberAccountInput struct {
	_ struct{} `type:"structure"`

	// The ID of the member account that you want to remove from Amazon Macie Classic.
	//
	// MemberAccountId is a required field
	MemberAccountId *string `locationName:"memberAccountId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateMemberAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberAccountInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateMemberAccountInput"}

	if s.MemberAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MemberAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateMemberAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateMemberAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateMemberAccount = "DisassociateMemberAccount"

// DisassociateMemberAccountRequest returns a request value for making API operation for
// Amazon Macie.
//
// Removes the specified member account from Amazon Macie Classic.
//
//    // Example sending a request using DisassociateMemberAccountRequest.
//    req := client.DisassociateMemberAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/DisassociateMemberAccount
func (c *Client) DisassociateMemberAccountRequest(input *DisassociateMemberAccountInput) DisassociateMemberAccountRequest {
	op := &aws.Operation{
		Name:       opDisassociateMemberAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateMemberAccountInput{}
	}

	req := c.newRequest(op, input, &DisassociateMemberAccountOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DisassociateMemberAccountRequest{Request: req, Input: input, Copy: c.DisassociateMemberAccountRequest}
}

// DisassociateMemberAccountRequest is the request type for the
// DisassociateMemberAccount API operation.
type DisassociateMemberAccountRequest struct {
	*aws.Request
	Input *DisassociateMemberAccountInput
	Copy  func(*DisassociateMemberAccountInput) DisassociateMemberAccountRequest
}

// Send marshals and sends the DisassociateMemberAccount API request.
func (r DisassociateMemberAccountRequest) Send(ctx context.Context) (*DisassociateMemberAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateMemberAccountResponse{
		DisassociateMemberAccountOutput: r.Request.Data.(*DisassociateMemberAccountOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateMemberAccountResponse is the response type for the
// DisassociateMemberAccount API operation.
type DisassociateMemberAccountResponse struct {
	*DisassociateMemberAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateMemberAccount request.
func (r *DisassociateMemberAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
