// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListFunctionEventInvokeConfigsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function.
	//
	// Name formats
	//
	//    * Function name - my-function.
	//
	//    * Function ARN - arn:aws:lambda:us-west-2:123456789012:function:my-function.
	//
	//    * Partial ARN - 123456789012:function:my-function.
	//
	// The length constraint applies only to the full ARN. If you specify only the
	// function name, it is limited to 64 characters in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of configurations to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListFunctionEventInvokeConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFunctionEventInvokeConfigsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListFunctionEventInvokeConfigsInput"}

	if s.FunctionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListFunctionEventInvokeConfigsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.FunctionName != nil {
		v := *s.FunctionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	return nil
}

type ListFunctionEventInvokeConfigsOutput struct {
	_ struct{} `type:"structure"`

	// A list of configurations.
	FunctionEventInvokeConfigs []FunctionEventInvokeConfig `type:"list"`

	// The pagination token that's included if more results are available.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListFunctionEventInvokeConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListFunctionEventInvokeConfigsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FunctionEventInvokeConfigs != nil {
		v := s.FunctionEventInvokeConfigs

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "FunctionEventInvokeConfigs", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListFunctionEventInvokeConfigs = "ListFunctionEventInvokeConfigs"

// ListFunctionEventInvokeConfigsRequest returns a request value for making API operation for
// AWS Lambda.
//
// Retrieves a list of configurations for asynchronous invocation for a function.
//
// To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.
//
//    // Example sending a request using ListFunctionEventInvokeConfigsRequest.
//    req := client.ListFunctionEventInvokeConfigsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs
func (c *Client) ListFunctionEventInvokeConfigsRequest(input *ListFunctionEventInvokeConfigsInput) ListFunctionEventInvokeConfigsRequest {
	op := &aws.Operation{
		Name:       opListFunctionEventInvokeConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/2019-09-25/functions/{FunctionName}/event-invoke-config/list",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFunctionEventInvokeConfigsInput{}
	}

	req := c.newRequest(op, input, &ListFunctionEventInvokeConfigsOutput{})

	return ListFunctionEventInvokeConfigsRequest{Request: req, Input: input, Copy: c.ListFunctionEventInvokeConfigsRequest}
}

// ListFunctionEventInvokeConfigsRequest is the request type for the
// ListFunctionEventInvokeConfigs API operation.
type ListFunctionEventInvokeConfigsRequest struct {
	*aws.Request
	Input *ListFunctionEventInvokeConfigsInput
	Copy  func(*ListFunctionEventInvokeConfigsInput) ListFunctionEventInvokeConfigsRequest
}

// Send marshals and sends the ListFunctionEventInvokeConfigs API request.
func (r ListFunctionEventInvokeConfigsRequest) Send(ctx context.Context) (*ListFunctionEventInvokeConfigsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListFunctionEventInvokeConfigsResponse{
		ListFunctionEventInvokeConfigsOutput: r.Request.Data.(*ListFunctionEventInvokeConfigsOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListFunctionEventInvokeConfigsRequestPaginator returns a paginator for ListFunctionEventInvokeConfigs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListFunctionEventInvokeConfigsRequest(input)
//   p := lambda.NewListFunctionEventInvokeConfigsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListFunctionEventInvokeConfigsPaginator(req ListFunctionEventInvokeConfigsRequest) ListFunctionEventInvokeConfigsPaginator {
	return ListFunctionEventInvokeConfigsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListFunctionEventInvokeConfigsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListFunctionEventInvokeConfigsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListFunctionEventInvokeConfigsPaginator struct {
	aws.Pager
}

func (p *ListFunctionEventInvokeConfigsPaginator) CurrentPage() *ListFunctionEventInvokeConfigsOutput {
	return p.Pager.CurrentPage().(*ListFunctionEventInvokeConfigsOutput)
}

// ListFunctionEventInvokeConfigsResponse is the response type for the
// ListFunctionEventInvokeConfigs API operation.
type ListFunctionEventInvokeConfigsResponse struct {
	*ListFunctionEventInvokeConfigsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListFunctionEventInvokeConfigs request.
func (r *ListFunctionEventInvokeConfigsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
