// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type PutMetadataInput struct {
	_ struct{} `type:"structure"`

	// ARN of the channel into which metadata is inserted. This channel must have
	// an active stream.
	//
	// ChannelArn is a required field
	ChannelArn *string `locationName:"channelArn" min:"1" type:"string" required:"true"`

	// Metadata to insert into the stream. Maximum: 1 KB per request.
	//
	// Metadata is a required field
	Metadata *string `locationName:"metadata" type:"string" required:"true"`
}

// String returns the string representation
func (s PutMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMetadataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutMetadataInput"}

	if s.ChannelArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelArn"))
	}
	if s.ChannelArn != nil && len(*s.ChannelArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelArn", 1))
	}

	if s.Metadata == nil {
		invalidParams.Add(aws.NewErrParamRequired("Metadata"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutMetadataInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ChannelArn != nil {
		v := *s.ChannelArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := *s.Metadata

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "metadata", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutMetadataOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutMetadata = "PutMetadata"

// PutMetadataRequest returns a request value for making API operation for
// Amazon Interactive Video Service.
//
// Inserts metadata into an RTMP stream for a specified channel. A maximum of
// 5 requests per second per channel is allowed, each with a maximum 1KB payload.
//
//    // Example sending a request using PutMetadataRequest.
//    req := client.PutMetadataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14/PutMetadata
func (c *Client) PutMetadataRequest(input *PutMetadataInput) PutMetadataRequest {
	op := &aws.Operation{
		Name:       opPutMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/PutMetadata",
	}

	if input == nil {
		input = &PutMetadataInput{}
	}

	req := c.newRequest(op, input, &PutMetadataOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return PutMetadataRequest{Request: req, Input: input, Copy: c.PutMetadataRequest}
}

// PutMetadataRequest is the request type for the
// PutMetadata API operation.
type PutMetadataRequest struct {
	*aws.Request
	Input *PutMetadataInput
	Copy  func(*PutMetadataInput) PutMetadataRequest
}

// Send marshals and sends the PutMetadata API request.
func (r PutMetadataRequest) Send(ctx context.Context) (*PutMetadataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutMetadataResponse{
		PutMetadataOutput: r.Request.Data.(*PutMetadataOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutMetadataResponse is the response type for the
// PutMetadata API operation.
type PutMetadataResponse struct {
	*PutMetadataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutMetadata request.
func (r *PutMetadataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
