// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ivs provides the client and types for making API
// requests to Amazon IVS.
//
// Introduction
//
// The Amazon Interactive Video Service (IVS) API is REST compatible, using
// a standard HTTP API and an AWS SNS (http://aws.amazon.com/sns) event stream
// for responses. JSON is used for both requests and responses, including errors.
//
// The API is an AWS regional service, currently in these regions: us-west-2,
// us-east-2, and eu-west-1.
//
//  All API request parameters and URLs are case sensitive.
//
// For a summary of notable documentation changes in each release, see Document
// History (https://docs.aws.amazon.com/ivs/latest/userguide/doc-history.html).
//
// Allowed Header Values
//
//    * Accept: application/json
//
//    * Accept-Encoding: gzip, deflate
//
//    * Content-Type: application/json
//
// Resources
//
// The following resources contain information about your IVS live stream (see
// Getting Started with Amazon IVS (https://docs.aws.amazon.com/ivs/latest/userguide/GSIVS.html)):
//
//    * Channel — Stores configuration data related to your live stream. You
//    first create a channel and then use the channel’s stream key to start
//    your live stream. See the Channel endpoints for more information.
//
//    * Stream key — An identifier assigned by Amazon IVS when you create
//    a channel, which is then used to authorize streaming. See the StreamKey
//    endpoints for more information. Treat the stream key like a secret, since
//    it allows anyone to stream to the channel.
//
// Tagging
//
// A tag is a metadata label that you assign to an AWS resource. A tag comprises
// a key and a value, both set by you. For example, you might set a tag as topic:nature
// to label a particular video category. See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
// for more information, including restrictions that apply to tags.
//
// Tags can help you identify and organize your AWS resources. For example,
// you can use the same tag for different resources to indicate that they are
// related. You can also use tags to manage access (see Access Tags (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)).
//
// The Amazon IVS API has these tag-related endpoints: TagResource, UntagResource,
// and ListTagsForResource. The following resources support tagging: Channels
// and Stream Keys.
//
// API Endpoints
//
// Channel:
//
//    * CreateChannel — Creates a new channel and an associated stream key
//    to start streaming.
//
//    * GetChannel — Gets the channel configuration for a specified channel
//    ARN (Amazon Resource Name).
//
//    * BatchGetChannel — Performs GetChannel on multiple ARNs simultaneously.
//
//    * ListChannels — Gets summary information about channels. This list
//    can be filtered to match a specified string.
//
//    * UpdateChannel — Updates a channel's configuration. This does not affect
//    an ongoing stream of this channel. You must stop and restart the stream
//    for the changes to take effect.
//
//    * DeleteChannel — Deletes a specified channel.
//
// StreamKey:
//
//    * CreateStreamKey — Creates a stream key, used to initiate a stream,
//    for a specified channel ARN.
//
//    * GetStreamKey — Gets stream key information for the specified ARN.
//
//    * BatchGetStreamKey — Performs GetStreamKey on multiple ARNs simultaneously.
//
//    * ListStreamKeys — Gets a list of stream keys. The list can be filtered
//    to a particular channel.
//
//    * DeleteStreamKey — Deletes the stream key for a specified ARN, so it
//    can no longer be used to stream.
//
// Stream:
//
//    * GetStream — Gets information about the active (live) stream on a specified
//    channel.
//
//    * ListStreams — Gets summary information about live streams.
//
//    * StopStream — Disconnects a streamer on a specified channel. This disconnects
//    the incoming RTMP stream from the client. Can be used in conjunction with
//    DeleteStreamKey to prevent further streaming to a channel.
//
//    * PutMetadata Inserts metadata into an RTMP stream for a specified channel.
//    A maximum of 5 requests per second per channel is allowed, each with a
//    maximum 1KB payload.
//
//  AWS Tags (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html):
//
//    * TagResource — Adds or updates tags for an AWS resource with a specified
//    ARN.
//
//    * UntagResource — Removes tags from a resource with a specified ARN.
//
//    * ListTagsForResource — Gets information about AWS tags for a specified
//    ARN.
//
// See https://docs.aws.amazon.com/goto/WebAPI/ivs-2020-07-14 for more information on this service.
//
// See ivs package documentation for more information.
// https://docs.aws.amazon.com/sdk-for-go/api/service/ivs/
//
// Using the Client
//
// To use Amazon IVS with the SDK use the New function to create
// a new service client. With that client you can make API requests to the service.
// These clients are safe to use concurrently.
//
// See the SDK's documentation for more information on how to use the SDK.
// https://docs.aws.amazon.com/sdk-for-go/api/
//
// See aws.Config documentation for more information on configuring SDK clients.
// https://docs.aws.amazon.com/sdk-for-go/api/aws/#Config
//
// See the Amazon IVS client for more information on
// creating client for this service.
// https://docs.aws.amazon.com/sdk-for-go/api/service/ivs/#New
package ivs
