// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SearchFlowTemplatesInput struct {
	_ struct{} `type:"structure"`

	// An array of objects that limit the result set. The only valid filter is DEVICE_MODEL_ID.
	Filters []FlowTemplateFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchFlowTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchFlowTemplatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchFlowTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SearchFlowTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain summary information about each workflow
	// in the result set.
	Summaries []FlowTemplateSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation
func (s SearchFlowTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchFlowTemplates = "SearchFlowTemplates"

// SearchFlowTemplatesRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Searches for summary information about workflows.
//
//    // Example sending a request using SearchFlowTemplatesRequest.
//    req := client.SearchFlowTemplatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates
func (c *Client) SearchFlowTemplatesRequest(input *SearchFlowTemplatesInput) SearchFlowTemplatesRequest {
	op := &aws.Operation{
		Name:       opSearchFlowTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchFlowTemplatesInput{}
	}

	req := c.newRequest(op, input, &SearchFlowTemplatesOutput{})

	return SearchFlowTemplatesRequest{Request: req, Input: input, Copy: c.SearchFlowTemplatesRequest}
}

// SearchFlowTemplatesRequest is the request type for the
// SearchFlowTemplates API operation.
type SearchFlowTemplatesRequest struct {
	*aws.Request
	Input *SearchFlowTemplatesInput
	Copy  func(*SearchFlowTemplatesInput) SearchFlowTemplatesRequest
}

// Send marshals and sends the SearchFlowTemplates API request.
func (r SearchFlowTemplatesRequest) Send(ctx context.Context) (*SearchFlowTemplatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchFlowTemplatesResponse{
		SearchFlowTemplatesOutput: r.Request.Data.(*SearchFlowTemplatesOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchFlowTemplatesRequestPaginator returns a paginator for SearchFlowTemplates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchFlowTemplatesRequest(input)
//   p := iotthingsgraph.NewSearchFlowTemplatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchFlowTemplatesPaginator(req SearchFlowTemplatesRequest) SearchFlowTemplatesPaginator {
	return SearchFlowTemplatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchFlowTemplatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchFlowTemplatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchFlowTemplatesPaginator struct {
	aws.Pager
}

func (p *SearchFlowTemplatesPaginator) CurrentPage() *SearchFlowTemplatesOutput {
	return p.Pager.CurrentPage().(*SearchFlowTemplatesOutput)
}

// SearchFlowTemplatesResponse is the response type for the
// SearchFlowTemplates API operation.
type SearchFlowTemplatesResponse struct {
	*SearchFlowTemplatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchFlowTemplates request.
func (r *SearchFlowTemplatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
