// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SearchEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The entity types for which to search.
	//
	// EntityTypes is a required field
	EntityTypes []EntityType `locationName:"entityTypes" type:"list" required:"true"`

	// Optional filter to apply to the search. Valid filters are NAME NAMESPACE,
	// SEMANTIC_TYPE_PATH and REFERENCED_ENTITY_ID. REFERENCED_ENTITY_ID filters
	// on entities that are used by the entity in the result set. For example, you
	// can filter on the ID of a property that is used in a state.
	//
	// Multiple filters function as OR criteria in the query. Multiple values passed
	// inside the filter function as AND criteria.
	Filters []EntityFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The version of the user's namespace. Defaults to the latest version of the
	// user's namespace.
	NamespaceVersion *int64 `locationName:"namespaceVersion" type:"long"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchEntitiesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchEntitiesInput"}

	if s.EntityTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("EntityTypes"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SearchEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// An array of descriptions for each entity returned in the search result.
	Descriptions []EntityDescription `locationName:"descriptions" type:"list"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchEntities = "SearchEntities"

// SearchEntitiesRequest returns a request value for making API operation for
// AWS IoT Things Graph.
//
// Searches for entities of the specified type. You can search for entities
// in your namespace and the public namespace that you're tracking.
//
//    // Example sending a request using SearchEntitiesRequest.
//    req := client.SearchEntitiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities
func (c *Client) SearchEntitiesRequest(input *SearchEntitiesInput) SearchEntitiesRequest {
	op := &aws.Operation{
		Name:       opSearchEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchEntitiesInput{}
	}

	req := c.newRequest(op, input, &SearchEntitiesOutput{})

	return SearchEntitiesRequest{Request: req, Input: input, Copy: c.SearchEntitiesRequest}
}

// SearchEntitiesRequest is the request type for the
// SearchEntities API operation.
type SearchEntitiesRequest struct {
	*aws.Request
	Input *SearchEntitiesInput
	Copy  func(*SearchEntitiesInput) SearchEntitiesRequest
}

// Send marshals and sends the SearchEntities API request.
func (r SearchEntitiesRequest) Send(ctx context.Context) (*SearchEntitiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchEntitiesResponse{
		SearchEntitiesOutput: r.Request.Data.(*SearchEntitiesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchEntitiesRequestPaginator returns a paginator for SearchEntities.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchEntitiesRequest(input)
//   p := iotthingsgraph.NewSearchEntitiesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchEntitiesPaginator(req SearchEntitiesRequest) SearchEntitiesPaginator {
	return SearchEntitiesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchEntitiesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchEntitiesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchEntitiesPaginator struct {
	aws.Pager
}

func (p *SearchEntitiesPaginator) CurrentPage() *SearchEntitiesOutput {
	return p.Pager.CurrentPage().(*SearchEntitiesOutput)
}

// SearchEntitiesResponse is the response type for the
// SearchEntities API operation.
type SearchEntitiesResponse struct {
	*SearchEntitiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchEntities request.
func (r *SearchEntitiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
