// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListPortalsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListPortalsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPortalsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPortalsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPortalsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListPortalsOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list that summarizes each portal.
	PortalSummaries []PortalSummary `locationName:"portalSummaries" type:"list"`
}

// String returns the string representation
func (s ListPortalsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPortalsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalSummaries != nil {
		v := s.PortalSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "portalSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListPortals = "ListPortals"

// ListPortalsRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Retrieves a paginated list of AWS IoT SiteWise Monitor portals.
//
//    // Example sending a request using ListPortalsRequest.
//    req := client.ListPortalsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals
func (c *Client) ListPortalsRequest(input *ListPortalsInput) ListPortalsRequest {
	op := &aws.Operation{
		Name:       opListPortals,
		HTTPMethod: "GET",
		HTTPPath:   "/portals",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPortalsInput{}
	}

	req := c.newRequest(op, input, &ListPortalsOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return ListPortalsRequest{Request: req, Input: input, Copy: c.ListPortalsRequest}
}

// ListPortalsRequest is the request type for the
// ListPortals API operation.
type ListPortalsRequest struct {
	*aws.Request
	Input *ListPortalsInput
	Copy  func(*ListPortalsInput) ListPortalsRequest
}

// Send marshals and sends the ListPortals API request.
func (r ListPortalsRequest) Send(ctx context.Context) (*ListPortalsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPortalsResponse{
		ListPortalsOutput: r.Request.Data.(*ListPortalsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPortalsRequestPaginator returns a paginator for ListPortals.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPortalsRequest(input)
//   p := iotsitewise.NewListPortalsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPortalsPaginator(req ListPortalsRequest) ListPortalsPaginator {
	return ListPortalsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPortalsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPortalsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPortalsPaginator struct {
	aws.Pager
}

func (p *ListPortalsPaginator) CurrentPage() *ListPortalsOutput {
	return p.Pager.CurrentPage().(*ListPortalsOutput)
}

// ListPortalsResponse is the response type for the
// ListPortals API operation.
type ListPortalsResponse struct {
	*ListPortalsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPortals request.
func (r *ListPortalsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
