// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListAccessPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the identity. This parameter is required if you specify identityType.
	IdentityId *string `location:"querystring" locationName:"identityId" min:"1" type:"string"`

	// The type of identity (user or group). This parameter is required if you specify
	// identityId.
	IdentityType IdentityType `location:"querystring" locationName:"identityType" type:"string" enum:"true"`

	// The maximum number of results to be returned per paginated request.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to be used for the next set of paginated results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The ID of the resource. This parameter is required if you specify resourceType.
	ResourceId *string `location:"querystring" locationName:"resourceId" min:"36" type:"string"`

	// The type of resource (portal or project). This parameter is required if you
	// specify resourceId.
	ResourceType ResourceType `location:"querystring" locationName:"resourceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListAccessPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPoliciesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAccessPoliciesInput"}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAccessPoliciesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.IdentityId != nil {
		v := *s.IdentityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "identityId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.IdentityType) > 0 {
		v := s.IdentityType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "identityType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "resourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type ListAccessPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list that summarizes each access policy.
	//
	// AccessPolicySummaries is a required field
	AccessPolicySummaries []AccessPolicySummary `locationName:"accessPolicySummaries" type:"list" required:"true"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAccessPoliciesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessPolicySummaries != nil {
		v := s.AccessPolicySummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "accessPolicySummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListAccessPolicies = "ListAccessPolicies"

// ListAccessPoliciesRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Retrieves a paginated list of access policies for an AWS SSO identity (a
// user or group) or an AWS IoT SiteWise Monitor resource (a portal or project).
//
//    // Example sending a request using ListAccessPoliciesRequest.
//    req := client.ListAccessPoliciesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies
func (c *Client) ListAccessPoliciesRequest(input *ListAccessPoliciesInput) ListAccessPoliciesRequest {
	op := &aws.Operation{
		Name:       opListAccessPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/access-policies",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPoliciesInput{}
	}

	req := c.newRequest(op, input, &ListAccessPoliciesOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return ListAccessPoliciesRequest{Request: req, Input: input, Copy: c.ListAccessPoliciesRequest}
}

// ListAccessPoliciesRequest is the request type for the
// ListAccessPolicies API operation.
type ListAccessPoliciesRequest struct {
	*aws.Request
	Input *ListAccessPoliciesInput
	Copy  func(*ListAccessPoliciesInput) ListAccessPoliciesRequest
}

// Send marshals and sends the ListAccessPolicies API request.
func (r ListAccessPoliciesRequest) Send(ctx context.Context) (*ListAccessPoliciesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAccessPoliciesResponse{
		ListAccessPoliciesOutput: r.Request.Data.(*ListAccessPoliciesOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAccessPoliciesRequestPaginator returns a paginator for ListAccessPolicies.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAccessPoliciesRequest(input)
//   p := iotsitewise.NewListAccessPoliciesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAccessPoliciesPaginator(req ListAccessPoliciesRequest) ListAccessPoliciesPaginator {
	return ListAccessPoliciesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAccessPoliciesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAccessPoliciesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAccessPoliciesPaginator struct {
	aws.Pager
}

func (p *ListAccessPoliciesPaginator) CurrentPage() *ListAccessPoliciesOutput {
	return p.Pager.CurrentPage().(*ListAccessPoliciesOutput)
}

// ListAccessPoliciesResponse is the response type for the
// ListAccessPolicies API operation.
type ListAccessPoliciesResponse struct {
	*ListAccessPoliciesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAccessPolicies request.
func (r *ListAccessPoliciesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
