// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribePortalInput struct {
	_ struct{} `type:"structure"`

	// The ID of the portal.
	//
	// PortalId is a required field
	PortalId *string `location:"uri" locationName:"portalId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePortalInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePortalInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribePortalInput"}

	if s.PortalId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortalId"))
	}
	if s.PortalId != nil && len(*s.PortalId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PortalId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribePortalInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PortalId != nil {
		v := *s.PortalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "portalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribePortalOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the portal, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"1" type:"string" required:"true"`

	// The AWS SSO application generated client ID (used with AWS SSO APIs).
	//
	// PortalClientId is a required field
	PortalClientId *string `locationName:"portalClientId" min:"1" type:"string" required:"true"`

	// The AWS administrator's contact email address.
	//
	// PortalContactEmail is a required field
	PortalContactEmail *string `locationName:"portalContactEmail" min:"1" type:"string" required:"true"`

	// The date the portal was created, in Unix epoch time.
	//
	// PortalCreationDate is a required field
	PortalCreationDate *time.Time `locationName:"portalCreationDate" type:"timestamp" required:"true"`

	// The portal's description.
	PortalDescription *string `locationName:"portalDescription" min:"1" type:"string"`

	// The ID of the portal.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// The date the portal was last updated, in Unix epoch time.
	//
	// PortalLastUpdateDate is a required field
	PortalLastUpdateDate *time.Time `locationName:"portalLastUpdateDate" type:"timestamp" required:"true"`

	// The portal's logo image, which is available at a URL.
	PortalLogoImageLocation *ImageLocation `locationName:"portalLogoImageLocation" type:"structure"`

	// The name of the portal.
	//
	// PortalName is a required field
	PortalName *string `locationName:"portalName" min:"1" type:"string" required:"true"`

	// The public root URL for the AWS IoT AWS IoT SiteWise Monitor application
	// portal.
	//
	// PortalStartUrl is a required field
	PortalStartUrl *string `locationName:"portalStartUrl" min:"1" type:"string" required:"true"`

	// The current status of the portal, which contains a state and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the service role that allows the portal's users to access your AWS IoT
	// SiteWise resources on your behalf. For more information, see Using service
	// roles for AWS IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the AWS IoT SiteWise User Guide.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribePortalOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PortalArn != nil {
		v := *s.PortalArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalClientId != nil {
		v := *s.PortalClientId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalClientId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalContactEmail != nil {
		v := *s.PortalContactEmail

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalContactEmail", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalCreationDate != nil {
		v := *s.PortalCreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalCreationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.PortalDescription != nil {
		v := *s.PortalDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalId != nil {
		v := *s.PortalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalLastUpdateDate != nil {
		v := *s.PortalLastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalLastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.PortalLogoImageLocation != nil {
		v := s.PortalLogoImageLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portalLogoImageLocation", v, metadata)
	}
	if s.PortalName != nil {
		v := *s.PortalName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalStartUrl != nil {
		v := *s.PortalStartUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalStartUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalStatus != nil {
		v := s.PortalStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portalStatus", v, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribePortal = "DescribePortal"

// DescribePortalRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Retrieves information about a portal.
//
//    // Example sending a request using DescribePortalRequest.
//    req := client.DescribePortalRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal
func (c *Client) DescribePortalRequest(input *DescribePortalInput) DescribePortalRequest {
	op := &aws.Operation{
		Name:       opDescribePortal,
		HTTPMethod: "GET",
		HTTPPath:   "/portals/{portalId}",
	}

	if input == nil {
		input = &DescribePortalInput{}
	}

	req := c.newRequest(op, input, &DescribePortalOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return DescribePortalRequest{Request: req, Input: input, Copy: c.DescribePortalRequest}
}

// DescribePortalRequest is the request type for the
// DescribePortal API operation.
type DescribePortalRequest struct {
	*aws.Request
	Input *DescribePortalInput
	Copy  func(*DescribePortalInput) DescribePortalRequest
}

// Send marshals and sends the DescribePortal API request.
func (r DescribePortalRequest) Send(ctx context.Context) (*DescribePortalResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePortalResponse{
		DescribePortalOutput: r.Request.Data.(*DescribePortalOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribePortalResponse is the response type for the
// DescribePortal API operation.
type DescribePortalResponse struct {
	*DescribePortalOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePortal request.
func (r *DescribePortalResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
