// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeGatewayInput struct {
	_ struct{} `type:"structure"`

	// The ID of the gateway device.
	//
	// GatewayId is a required field
	GatewayId *string `location:"uri" locationName:"gatewayId" min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeGatewayInput"}

	if s.GatewayId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayId"))
	}
	if s.GatewayId != nil && len(*s.GatewayId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeGatewayInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.GatewayId != nil {
		v := *s.GatewayId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "gatewayId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeGatewayOutput struct {
	_ struct{} `type:"structure"`

	// The date the gateway was created, in Unix epoch time.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the gateway, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}
	//
	// GatewayArn is a required field
	GatewayArn *string `locationName:"gatewayArn" min:"1" type:"string" required:"true"`

	// A list of gateway capability summaries that each contain a namespace and
	// status. Each gateway capability defines data sources for the gateway. To
	// retrieve a capability configuration's definition, use DescribeGatewayCapabilityConfiguration
	// (https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html).
	//
	// GatewayCapabilitySummaries is a required field
	GatewayCapabilitySummaries []GatewayCapabilitySummary `locationName:"gatewayCapabilitySummaries" type:"list" required:"true"`

	// The ID of the gateway device.
	//
	// GatewayId is a required field
	GatewayId *string `locationName:"gatewayId" min:"36" type:"string" required:"true"`

	// The name of the gateway.
	//
	// GatewayName is a required field
	GatewayName *string `locationName:"gatewayName" min:"1" type:"string" required:"true"`

	// The gateway's platform.
	GatewayPlatform *GatewayPlatform `locationName:"gatewayPlatform" type:"structure"`

	// The date the gateway was last updated, in Unix epoch time.
	//
	// LastUpdateDate is a required field
	LastUpdateDate *time.Time `locationName:"lastUpdateDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s DescribeGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeGatewayOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.GatewayArn != nil {
		v := *s.GatewayArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gatewayArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GatewayCapabilitySummaries != nil {
		v := s.GatewayCapabilitySummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "gatewayCapabilitySummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.GatewayId != nil {
		v := *s.GatewayId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gatewayId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GatewayName != nil {
		v := *s.GatewayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gatewayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GatewayPlatform != nil {
		v := s.GatewayPlatform

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "gatewayPlatform", v, metadata)
	}
	if s.LastUpdateDate != nil {
		v := *s.LastUpdateDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateDate",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

const opDescribeGateway = "DescribeGateway"

// DescribeGatewayRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Retrieves information about a gateway.
//
//    // Example sending a request using DescribeGatewayRequest.
//    req := client.DescribeGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway
func (c *Client) DescribeGatewayRequest(input *DescribeGatewayInput) DescribeGatewayRequest {
	op := &aws.Operation{
		Name:       opDescribeGateway,
		HTTPMethod: "GET",
		HTTPPath:   "/20200301/gateways/{gatewayId}",
	}

	if input == nil {
		input = &DescribeGatewayInput{}
	}

	req := c.newRequest(op, input, &DescribeGatewayOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("edge.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return DescribeGatewayRequest{Request: req, Input: input, Copy: c.DescribeGatewayRequest}
}

// DescribeGatewayRequest is the request type for the
// DescribeGateway API operation.
type DescribeGatewayRequest struct {
	*aws.Request
	Input *DescribeGatewayInput
	Copy  func(*DescribeGatewayInput) DescribeGatewayRequest
}

// Send marshals and sends the DescribeGateway API request.
func (r DescribeGatewayRequest) Send(ctx context.Context) (*DescribeGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeGatewayResponse{
		DescribeGatewayOutput: r.Request.Data.(*DescribeGatewayOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeGatewayResponse is the response type for the
// DescribeGateway API operation.
type DescribeGatewayResponse struct {
	*DescribeGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeGateway request.
func (r *DescribeGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
