// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotsitewise

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreatePortalInput struct {
	_ struct{} `type:"structure"`

	// A unique case-sensitive identifier that you can provide to ensure the idempotency
	// of the request. Don't reuse this client token if a new idempotent request
	// is required.
	ClientToken *string `locationName:"clientToken" min:"36" type:"string" idempotencyToken:"true"`

	// The AWS administrator's contact email address.
	//
	// PortalContactEmail is a required field
	PortalContactEmail *string `locationName:"portalContactEmail" min:"1" type:"string" required:"true"`

	// A description for the portal.
	PortalDescription *string `locationName:"portalDescription" min:"1" type:"string"`

	// A logo image to display in the portal. Upload a square, high-resolution image.
	// The image is displayed on a dark background.
	PortalLogoImageFile *ImageFile `locationName:"portalLogoImageFile" type:"structure"`

	// A friendly name for the portal.
	//
	// PortalName is a required field
	PortalName *string `locationName:"portalName" min:"1" type:"string" required:"true"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of a service role that allows the portal's users to access your AWS IoT SiteWise
	// resources on your behalf. For more information, see Using service roles for
	// AWS IoT SiteWise Monitor (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html)
	// in the AWS IoT SiteWise User Guide.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// A list of key-value pairs that contain metadata for the portal. For more
	// information, see Tagging your AWS IoT SiteWise resources (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html)
	// in the AWS IoT SiteWise User Guide.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreatePortalInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePortalInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePortalInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 36))
	}

	if s.PortalContactEmail == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortalContactEmail"))
	}
	if s.PortalContactEmail != nil && len(*s.PortalContactEmail) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PortalContactEmail", 1))
	}
	if s.PortalDescription != nil && len(*s.PortalDescription) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PortalDescription", 1))
	}

	if s.PortalName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortalName"))
	}
	if s.PortalName != nil && len(*s.PortalName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PortalName", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.PortalLogoImageFile != nil {
		if err := s.PortalLogoImageFile.Validate(); err != nil {
			invalidParams.AddNested("PortalLogoImageFile", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreatePortalInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalContactEmail != nil {
		v := *s.PortalContactEmail

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalContactEmail", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalDescription != nil {
		v := *s.PortalDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalLogoImageFile != nil {
		v := s.PortalLogoImageFile

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portalLogoImageFile", v, metadata)
	}
	if s.PortalName != nil {
		v := *s.PortalName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreatePortalOutput struct {
	_ struct{} `type:"structure"`

	// The ARN (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of the portal, which has the following format.
	//
	// arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}
	//
	// PortalArn is a required field
	PortalArn *string `locationName:"portalArn" min:"1" type:"string" required:"true"`

	// The ID of the created portal.
	//
	// PortalId is a required field
	PortalId *string `locationName:"portalId" min:"36" type:"string" required:"true"`

	// The public URL for the AWS IoT SiteWise Monitor portal.
	//
	// PortalStartUrl is a required field
	PortalStartUrl *string `locationName:"portalStartUrl" min:"1" type:"string" required:"true"`

	// The status of the portal, which contains a state (CREATING after successfully
	// calling this operation) and any error message.
	//
	// PortalStatus is a required field
	PortalStatus *PortalStatus `locationName:"portalStatus" type:"structure" required:"true"`

	// The associated AWS SSO application Id.
	//
	// SsoApplicationId is a required field
	SsoApplicationId *string `locationName:"ssoApplicationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePortalOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreatePortalOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PortalArn != nil {
		v := *s.PortalArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalId != nil {
		v := *s.PortalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalStartUrl != nil {
		v := *s.PortalStartUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portalStartUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortalStatus != nil {
		v := s.PortalStatus

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portalStatus", v, metadata)
	}
	if s.SsoApplicationId != nil {
		v := *s.SsoApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ssoApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreatePortal = "CreatePortal"

// CreatePortalRequest returns a request value for making API operation for
// AWS IoT SiteWise.
//
// Creates a portal, which can contain projects and dashboards. Before you can
// create a portal, you must configure AWS Single Sign-On in the current Region.
// AWS IoT SiteWise Monitor uses AWS SSO to manage user permissions. For more
// information, see Enabling AWS SSO (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-get-started.html#mon-gs-sso)
// in the AWS IoT SiteWise User Guide.
//
// Before you can sign in to a new portal, you must add at least one AWS SSO
// user or group to that portal. For more information, see Adding or Removing
// Portal Administrators (https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins)
// in the AWS IoT SiteWise User Guide.
//
//    // Example sending a request using CreatePortalRequest.
//    req := client.CreatePortalRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal
func (c *Client) CreatePortalRequest(input *CreatePortalInput) CreatePortalRequest {
	op := &aws.Operation{
		Name:       opCreatePortal,
		HTTPMethod: "POST",
		HTTPPath:   "/portals",
	}

	if input == nil {
		input = &CreatePortalInput{}
	}

	req := c.newRequest(op, input, &CreatePortalOutput{})
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("monitor.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)

	return CreatePortalRequest{Request: req, Input: input, Copy: c.CreatePortalRequest}
}

// CreatePortalRequest is the request type for the
// CreatePortal API operation.
type CreatePortalRequest struct {
	*aws.Request
	Input *CreatePortalInput
	Copy  func(*CreatePortalInput) CreatePortalRequest
}

// Send marshals and sends the CreatePortal API request.
func (r CreatePortalRequest) Send(ctx context.Context) (*CreatePortalResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePortalResponse{
		CreatePortalOutput: r.Request.Data.(*CreatePortalOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePortalResponse is the response type for the
// CreatePortal API operation.
type CreatePortalResponse struct {
	*CreatePortalOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePortal request.
func (r *CreatePortalResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
