// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot1clickdevicesservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UnclaimDeviceInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`
}

// String returns the string representation
func (s UnclaimDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnclaimDeviceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnclaimDeviceInput"}

	if s.DeviceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnclaimDeviceInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "deviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UnclaimDeviceOutput struct {
	_ struct{} `type:"structure"`

	State *string `locationName:"state" type:"string"`
}

// String returns the string representation
func (s UnclaimDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnclaimDeviceOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUnclaimDevice = "UnclaimDevice"

// UnclaimDeviceRequest returns a request value for making API operation for
// AWS IoT 1-Click Devices Service.
//
// Disassociates a device from your AWS account using its device ID.
//
//    // Example sending a request using UnclaimDeviceRequest.
//    req := client.UnclaimDeviceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/UnclaimDevice
func (c *Client) UnclaimDeviceRequest(input *UnclaimDeviceInput) UnclaimDeviceRequest {
	op := &aws.Operation{
		Name:       opUnclaimDevice,
		HTTPMethod: "PUT",
		HTTPPath:   "/devices/{deviceId}/unclaim",
	}

	if input == nil {
		input = &UnclaimDeviceInput{}
	}

	req := c.newRequest(op, input, &UnclaimDeviceOutput{})

	return UnclaimDeviceRequest{Request: req, Input: input, Copy: c.UnclaimDeviceRequest}
}

// UnclaimDeviceRequest is the request type for the
// UnclaimDevice API operation.
type UnclaimDeviceRequest struct {
	*aws.Request
	Input *UnclaimDeviceInput
	Copy  func(*UnclaimDeviceInput) UnclaimDeviceRequest
}

// Send marshals and sends the UnclaimDevice API request.
func (r UnclaimDeviceRequest) Send(ctx context.Context) (*UnclaimDeviceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnclaimDeviceResponse{
		UnclaimDeviceOutput: r.Request.Data.(*UnclaimDeviceOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnclaimDeviceResponse is the response type for the
// UnclaimDevice API operation.
type UnclaimDeviceResponse struct {
	*UnclaimDeviceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UnclaimDevice request.
func (r *UnclaimDeviceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
