// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartAuditMitigationActionsTaskInput struct {
	_ struct{} `type:"structure"`

	// For an audit check, specifies which mitigation actions to apply. Those actions
	// must be defined in your AWS account.
	//
	// AuditCheckToActionsMapping is a required field
	AuditCheckToActionsMapping map[string][]string `locationName:"auditCheckToActionsMapping" type:"map" required:"true"`

	// Each audit mitigation task must have a unique client request token. If you
	// try to start a new task with the same token as a task that already exists,
	// an exception occurs. If you omit this value, a unique client request token
	// is generated automatically.
	//
	// ClientRequestToken is a required field
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// Specifies the audit findings to which the mitigation actions are applied.
	// You can apply them to a type of audit check, to all findings from an audit,
	// or to a speecific set of findings.
	//
	// Target is a required field
	Target *AuditMitigationActionsTaskTarget `locationName:"target" type:"structure" required:"true"`

	// A unique identifier for the task. You can use this identifier to check the
	// status of the task or to cancel it.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartAuditMitigationActionsTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAuditMitigationActionsTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartAuditMitigationActionsTaskInput"}

	if s.AuditCheckToActionsMapping == nil {
		invalidParams.Add(aws.NewErrParamRequired("AuditCheckToActionsMapping"))
	}

	if s.ClientRequestToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientRequestToken"))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.Target == nil {
		invalidParams.Add(aws.NewErrParamRequired("Target"))
	}

	if s.TaskId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskId", 1))
	}
	if s.Target != nil {
		if err := s.Target.Validate(); err != nil {
			invalidParams.AddNested("Target", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartAuditMitigationActionsTaskInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AuditCheckToActionsMapping != nil {
		v := s.AuditCheckToActionsMapping

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "auditCheckToActionsMapping", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	var ClientRequestToken string
	if s.ClientRequestToken != nil {
		ClientRequestToken = *s.ClientRequestToken
	} else {
		ClientRequestToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Target != nil {
		v := s.Target

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "target", v, metadata)
	}
	if s.TaskId != nil {
		v := *s.TaskId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "taskId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StartAuditMitigationActionsTaskOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the audit mitigation task. This matches the taskId
	// that you specified in the request.
	TaskId *string `locationName:"taskId" min:"1" type:"string"`
}

// String returns the string representation
func (s StartAuditMitigationActionsTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartAuditMitigationActionsTaskOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.TaskId != nil {
		v := *s.TaskId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "taskId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opStartAuditMitigationActionsTask = "StartAuditMitigationActionsTask"

// StartAuditMitigationActionsTaskRequest returns a request value for making API operation for
// AWS IoT.
//
// Starts a task that applies a set of mitigation actions to the specified target.
//
//    // Example sending a request using StartAuditMitigationActionsTaskRequest.
//    req := client.StartAuditMitigationActionsTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) StartAuditMitigationActionsTaskRequest(input *StartAuditMitigationActionsTaskInput) StartAuditMitigationActionsTaskRequest {
	op := &aws.Operation{
		Name:       opStartAuditMitigationActionsTask,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/mitigationactions/tasks/{taskId}",
	}

	if input == nil {
		input = &StartAuditMitigationActionsTaskInput{}
	}

	req := c.newRequest(op, input, &StartAuditMitigationActionsTaskOutput{})

	return StartAuditMitigationActionsTaskRequest{Request: req, Input: input, Copy: c.StartAuditMitigationActionsTaskRequest}
}

// StartAuditMitigationActionsTaskRequest is the request type for the
// StartAuditMitigationActionsTask API operation.
type StartAuditMitigationActionsTaskRequest struct {
	*aws.Request
	Input *StartAuditMitigationActionsTaskInput
	Copy  func(*StartAuditMitigationActionsTaskInput) StartAuditMitigationActionsTaskRequest
}

// Send marshals and sends the StartAuditMitigationActionsTask API request.
func (r StartAuditMitigationActionsTaskRequest) Send(ctx context.Context) (*StartAuditMitigationActionsTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartAuditMitigationActionsTaskResponse{
		StartAuditMitigationActionsTaskOutput: r.Request.Data.(*StartAuditMitigationActionsTaskOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartAuditMitigationActionsTaskResponse is the response type for the
// StartAuditMitigationActionsTask API operation.
type StartAuditMitigationActionsTaskResponse struct {
	*StartAuditMitigationActionsTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartAuditMitigationActionsTask request.
func (r *StartAuditMitigationActionsTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
