// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetOTAUpdateInput struct {
	_ struct{} `type:"structure"`

	// The OTA update ID.
	//
	// OtaUpdateId is a required field
	OtaUpdateId *string `location:"uri" locationName:"otaUpdateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOTAUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOTAUpdateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetOTAUpdateInput"}

	if s.OtaUpdateId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OtaUpdateId"))
	}
	if s.OtaUpdateId != nil && len(*s.OtaUpdateId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OtaUpdateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetOTAUpdateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.OtaUpdateId != nil {
		v := *s.OtaUpdateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "otaUpdateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetOTAUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The OTA update info.
	OtaUpdateInfo *OTAUpdateInfo `locationName:"otaUpdateInfo" type:"structure"`
}

// String returns the string representation
func (s GetOTAUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetOTAUpdateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.OtaUpdateInfo != nil {
		v := s.OtaUpdateInfo

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "otaUpdateInfo", v, metadata)
	}
	return nil
}

const opGetOTAUpdate = "GetOTAUpdate"

// GetOTAUpdateRequest returns a request value for making API operation for
// AWS IoT.
//
// Gets an OTA update.
//
//    // Example sending a request using GetOTAUpdateRequest.
//    req := client.GetOTAUpdateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetOTAUpdateRequest(input *GetOTAUpdateInput) GetOTAUpdateRequest {
	op := &aws.Operation{
		Name:       opGetOTAUpdate,
		HTTPMethod: "GET",
		HTTPPath:   "/otaUpdates/{otaUpdateId}",
	}

	if input == nil {
		input = &GetOTAUpdateInput{}
	}

	req := c.newRequest(op, input, &GetOTAUpdateOutput{})

	return GetOTAUpdateRequest{Request: req, Input: input, Copy: c.GetOTAUpdateRequest}
}

// GetOTAUpdateRequest is the request type for the
// GetOTAUpdate API operation.
type GetOTAUpdateRequest struct {
	*aws.Request
	Input *GetOTAUpdateInput
	Copy  func(*GetOTAUpdateInput) GetOTAUpdateRequest
}

// Send marshals and sends the GetOTAUpdate API request.
func (r GetOTAUpdateRequest) Send(ctx context.Context) (*GetOTAUpdateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetOTAUpdateResponse{
		GetOTAUpdateOutput: r.Request.Data.(*GetOTAUpdateOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetOTAUpdateResponse is the response type for the
// GetOTAUpdate API operation.
type GetOTAUpdateResponse struct {
	*GetOTAUpdateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetOTAUpdate request.
func (r *GetOTAUpdateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
