// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateProvisioningTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// Sets a fleet provision template version as the default version.
	SetAsDefault *bool `location:"querystring" locationName:"setAsDefault" type:"boolean"`

	// The JSON formatted contents of the fleet provisioning template.
	//
	// TemplateBody is a required field
	TemplateBody *string `locationName:"templateBody" type:"string" required:"true"`

	// The name of the fleet provisioning template.
	//
	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProvisioningTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProvisioningTemplateVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateProvisioningTemplateVersionInput"}

	if s.TemplateBody == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateBody"))
	}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateProvisioningTemplateVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateBody != nil {
		v := *s.TemplateBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateBody", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "templateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SetAsDefault != nil {
		v := *s.SetAsDefault

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "setAsDefault", protocol.BoolValue(v), metadata)
	}
	return nil
}

type CreateProvisioningTemplateVersionOutput struct {
	_ struct{} `type:"structure"`

	// True if the fleet provisioning template version is the default version, otherwise
	// false.
	IsDefaultVersion *bool `locationName:"isDefaultVersion" type:"boolean"`

	// The ARN that identifies the provisioning template.
	TemplateArn *string `locationName:"templateArn" type:"string"`

	// The name of the fleet provisioning template.
	TemplateName *string `locationName:"templateName" min:"1" type:"string"`

	// The version of the fleet provisioning template.
	VersionId *int64 `locationName:"versionId" type:"integer"`
}

// String returns the string representation
func (s CreateProvisioningTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateProvisioningTemplateVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsDefaultVersion != nil {
		v := *s.IsDefaultVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isDefaultVersion", protocol.BoolValue(v), metadata)
	}
	if s.TemplateArn != nil {
		v := *s.TemplateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "versionId", protocol.Int64Value(v), metadata)
	}
	return nil
}

const opCreateProvisioningTemplateVersion = "CreateProvisioningTemplateVersion"

// CreateProvisioningTemplateVersionRequest returns a request value for making API operation for
// AWS IoT.
//
// Creates a new version of a fleet provisioning template.
//
//    // Example sending a request using CreateProvisioningTemplateVersionRequest.
//    req := client.CreateProvisioningTemplateVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateProvisioningTemplateVersionRequest(input *CreateProvisioningTemplateVersionInput) CreateProvisioningTemplateVersionRequest {
	op := &aws.Operation{
		Name:       opCreateProvisioningTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/provisioning-templates/{templateName}/versions",
	}

	if input == nil {
		input = &CreateProvisioningTemplateVersionInput{}
	}

	req := c.newRequest(op, input, &CreateProvisioningTemplateVersionOutput{})

	return CreateProvisioningTemplateVersionRequest{Request: req, Input: input, Copy: c.CreateProvisioningTemplateVersionRequest}
}

// CreateProvisioningTemplateVersionRequest is the request type for the
// CreateProvisioningTemplateVersion API operation.
type CreateProvisioningTemplateVersionRequest struct {
	*aws.Request
	Input *CreateProvisioningTemplateVersionInput
	Copy  func(*CreateProvisioningTemplateVersionInput) CreateProvisioningTemplateVersionRequest
}

// Send marshals and sends the CreateProvisioningTemplateVersion API request.
func (r CreateProvisioningTemplateVersionRequest) Send(ctx context.Context) (*CreateProvisioningTemplateVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateProvisioningTemplateVersionResponse{
		CreateProvisioningTemplateVersionOutput: r.Request.Data.(*CreateProvisioningTemplateVersionOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateProvisioningTemplateVersionResponse is the response type for the
// CreateProvisioningTemplateVersion API operation.
type CreateProvisioningTemplateVersionResponse struct {
	*CreateProvisioningTemplateVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateProvisioningTemplateVersion request.
func (r *CreateProvisioningTemplateVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
