// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Details of an EC2 AMI.
type Ami struct {
	_ struct{} `type:"structure"`

	// The description of the EC2 AMI.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The AMI ID of the EC2 AMI.
	Image *string `locationName:"image" min:"1" type:"string"`

	// The name of the EC2 AMI.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The AWS Region of the EC2 AMI.
	Region *string `locationName:"region" min:"1" type:"string"`

	// Image state shows the image status and the reason for that status.
	State *ImageState `locationName:"state" type:"structure"`
}

// String returns the string representation
func (s Ami) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Ami) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Image != nil {
		v := *s.Image

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "image", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "state", v, metadata)
	}
	return nil
}

// Define and configure the output AMIs of the pipeline.
type AmiDistributionConfiguration struct {
	_ struct{} `type:"structure"`

	// The tags to apply to AMIs distributed to this Region.
	AmiTags map[string]string `locationName:"amiTags" min:"1" type:"map"`

	// The description of the distribution configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The KMS key identifier used to encrypt the distributed image.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// Launch permissions can be used to configure which AWS accounts can use the
	// AMI to launch instances.
	LaunchPermission *LaunchPermissionConfiguration `locationName:"launchPermission" type:"structure"`

	// The name of the distribution configuration.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s AmiDistributionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmiDistributionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AmiDistributionConfiguration"}
	if s.AmiTags != nil && len(s.AmiTags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AmiTags", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AmiDistributionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.AmiTags != nil {
		v := s.AmiTags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "amiTags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KmsKeyId != nil {
		v := *s.KmsKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kmsKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchPermission != nil {
		v := s.LaunchPermission

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "launchPermission", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A detailed view of a component.
type Component struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component.
	Arn *string `locationName:"arn" type:"string"`

	// The change description of the component.
	ChangeDescription *string `locationName:"changeDescription" min:"1" type:"string"`

	// The data of the component.
	Data *string `locationName:"data" type:"string"`

	// The date that the component was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The description of the component.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The encryption status of the component.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// The KMS key identifier used to encrypt the component.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The name of the component.
	Name *string `locationName:"name" type:"string"`

	// The owner of the component.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The platform of the component.
	Platform Platform `locationName:"platform" type:"string" enum:"true"`

	// The operating system (OS) version supported by the component. If the OS information
	// is available, a prefix match is performed against the parent image OS version
	// during image recipe creation.
	SupportedOsVersions []string `locationName:"supportedOsVersions" min:"1" type:"list"`

	// The tags associated with the component.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The type of the component denotes whether the component is used to build
	// the image or only to test it.
	Type ComponentType `locationName:"type" type:"string" enum:"true"`

	// The version of the component.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s Component) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Component) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeDescription != nil {
		v := *s.ChangeDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "changeDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Data != nil {
		v := *s.Data

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "data", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Encrypted != nil {
		v := *s.Encrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "encrypted", protocol.BoolValue(v), metadata)
	}
	if s.KmsKeyId != nil {
		v := *s.KmsKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kmsKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SupportedOsVersions != nil {
		v := s.SupportedOsVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "supportedOsVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Configuration details of the component.
type ComponentConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component.
	//
	// ComponentArn is a required field
	ComponentArn *string `locationName:"componentArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ComponentConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComponentConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ComponentConfiguration"}

	if s.ComponentArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComponentArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ComponentConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ComponentArn != nil {
		v := *s.ComponentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "componentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A high-level summary of a component.
type ComponentSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component.
	Arn *string `locationName:"arn" type:"string"`

	// The change description of the component.
	ChangeDescription *string `locationName:"changeDescription" min:"1" type:"string"`

	// The date that the component was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The description of the component.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the component.
	Name *string `locationName:"name" type:"string"`

	// The owner of the component.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The platform of the component.
	Platform Platform `locationName:"platform" type:"string" enum:"true"`

	// The operating system (OS) version supported by the component. If the OS information
	// is available, a prefix match is performed against the parent image OS version
	// during image recipe creation.
	SupportedOsVersions []string `locationName:"supportedOsVersions" min:"1" type:"list"`

	// The tags associated with the component.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The type of the component denotes whether the component is used to build
	// the image or only to test it.
	Type ComponentType `locationName:"type" type:"string" enum:"true"`

	// The version of the component.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ComponentSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ComponentSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChangeDescription != nil {
		v := *s.ChangeDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "changeDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SupportedOsVersions != nil {
		v := s.SupportedOsVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "supportedOsVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A high-level overview of a component semantic version.
type ComponentVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component.
	Arn *string `locationName:"arn" type:"string"`

	// The date that the component was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The description of the component.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the component.
	Name *string `locationName:"name" type:"string"`

	// The owner of the component.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The platform of the component.
	Platform Platform `locationName:"platform" type:"string" enum:"true"`

	// The operating system (OS) version supported by the component. If the OS information
	// is available, a prefix match is performed against the parent image OS version
	// during image recipe creation.
	SupportedOsVersions []string `locationName:"supportedOsVersions" min:"1" type:"list"`

	// The type of the component denotes whether the component is used to build
	// the image or only to test it.
	Type ComponentType `locationName:"type" type:"string" enum:"true"`

	// The semantic version of the component.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ComponentVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ComponentVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SupportedOsVersions != nil {
		v := s.SupportedOsVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "supportedOsVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Defines the settings for a specific Region.
type Distribution struct {
	_ struct{} `type:"structure"`

	// The specific AMI settings (for example, launch permissions, AMI tags).
	AmiDistributionConfiguration *AmiDistributionConfiguration `locationName:"amiDistributionConfiguration" type:"structure"`

	// The License Manager Configuration to associate with the AMI in the specified
	// Region.
	LicenseConfigurationArns []string `locationName:"licenseConfigurationArns" type:"list"`

	// The target Region.
	//
	// Region is a required field
	Region *string `locationName:"region" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Distribution) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Distribution) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Distribution"}

	if s.Region == nil {
		invalidParams.Add(aws.NewErrParamRequired("Region"))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Region", 1))
	}
	if s.AmiDistributionConfiguration != nil {
		if err := s.AmiDistributionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AmiDistributionConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Distribution) MarshalFields(e protocol.FieldEncoder) error {
	if s.AmiDistributionConfiguration != nil {
		v := s.AmiDistributionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "amiDistributionConfiguration", v, metadata)
	}
	if s.LicenseConfigurationArns != nil {
		v := s.LicenseConfigurationArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "licenseConfigurationArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A distribution configuration.
type DistributionConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the distribution configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which this distribution configuration was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The date on which this distribution configuration was last updated.
	DateUpdated *string `locationName:"dateUpdated" type:"string"`

	// The description of the distribution configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The distributions of the distribution configuration.
	Distributions []Distribution `locationName:"distributions" type:"list"`

	// The name of the distribution configuration.
	Name *string `locationName:"name" type:"string"`

	// The tags of the distribution configuration.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The maximum duration in minutes for this distribution configuration.
	//
	// TimeoutMinutes is a required field
	TimeoutMinutes *int64 `locationName:"timeoutMinutes" min:"30" type:"integer" required:"true"`
}

// String returns the string representation
func (s DistributionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DistributionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateUpdated != nil {
		v := *s.DateUpdated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateUpdated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Distributions != nil {
		v := s.Distributions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "distributions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TimeoutMinutes != nil {
		v := *s.TimeoutMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeoutMinutes", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A high-level overview of a distribution configuration.
type DistributionConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the distribution configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which the distribution configuration was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The date on which the distribution configuration was updated.
	DateUpdated *string `locationName:"dateUpdated" type:"string"`

	// The description of the distribution configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the distribution configuration.
	Name *string `locationName:"name" type:"string"`

	// The tags associated with the distribution configuration.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s DistributionConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DistributionConfigurationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateUpdated != nil {
		v := *s.DateUpdated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateUpdated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Amazon EBS-specific block device mapping specifications.
type EbsInstanceBlockDeviceSpecification struct {
	_ struct{} `type:"structure"`

	// Use to configure delete on termination of the associated device.
	DeleteOnTermination *bool `locationName:"deleteOnTermination" type:"boolean"`

	// Use to configure device encryption.
	Encrypted *bool `locationName:"encrypted" type:"boolean"`

	// Use to configure device IOPS.
	Iops *int64 `locationName:"iops" min:"100" type:"integer"`

	// Use to configure the KMS key to use when encrypting the device.
	KmsKeyId *string `locationName:"kmsKeyId" min:"1" type:"string"`

	// The snapshot that defines the device contents.
	SnapshotId *string `locationName:"snapshotId" min:"1" type:"string"`

	// Use to override the device's volume size.
	VolumeSize *int64 `locationName:"volumeSize" min:"1" type:"integer"`

	// Use to override the device's volume type.
	VolumeType EbsVolumeType `locationName:"volumeType" type:"string" enum:"true"`
}

// String returns the string representation
func (s EbsInstanceBlockDeviceSpecification) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EbsInstanceBlockDeviceSpecification) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EbsInstanceBlockDeviceSpecification"}
	if s.Iops != nil && *s.Iops < 100 {
		invalidParams.Add(aws.NewErrParamMinValue("Iops", 100))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnapshotId", 1))
	}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VolumeSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EbsInstanceBlockDeviceSpecification) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeleteOnTermination != nil {
		v := *s.DeleteOnTermination

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deleteOnTermination", protocol.BoolValue(v), metadata)
	}
	if s.Encrypted != nil {
		v := *s.Encrypted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "encrypted", protocol.BoolValue(v), metadata)
	}
	if s.Iops != nil {
		v := *s.Iops

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "iops", protocol.Int64Value(v), metadata)
	}
	if s.KmsKeyId != nil {
		v := *s.KmsKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kmsKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SnapshotId != nil {
		v := *s.SnapshotId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "snapshotId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VolumeSize != nil {
		v := *s.VolumeSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "volumeSize", protocol.Int64Value(v), metadata)
	}
	if len(s.VolumeType) > 0 {
		v := s.VolumeType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "volumeType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A filter name and value pair that is used to return a more specific list
// of results from a list operation. Filters can be used to match a set of resources
// by specific criteria, such as tags, attributes, or IDs.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	Name *string `locationName:"name" type:"string"`

	// The filter values. Filter values are case-sensitive.
	Values []string `locationName:"values" min:"1" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Filter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Values != nil {
		v := s.Values

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "values", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// An image build version.
type Image struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which this image was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The distribution configuration used when creating this image.
	DistributionConfiguration *DistributionConfiguration `locationName:"distributionConfiguration" type:"structure"`

	// Collects additional information about the image being created, including
	// the operating system (OS) version and package list. This information is used
	// to enhance the overall experience of using EC2 Image Builder. Enabled by
	// default.
	EnhancedImageMetadataEnabled *bool `locationName:"enhancedImageMetadataEnabled" type:"boolean"`

	// The image recipe used when creating the image.
	ImageRecipe *ImageRecipe `locationName:"imageRecipe" type:"structure"`

	// The image tests configuration used when creating this image.
	ImageTestsConfiguration *ImageTestsConfiguration `locationName:"imageTestsConfiguration" type:"structure"`

	// The infrastructure used when creating this image.
	InfrastructureConfiguration *InfrastructureConfiguration `locationName:"infrastructureConfiguration" type:"structure"`

	// The name of the image.
	Name *string `locationName:"name" type:"string"`

	// The operating system version of the instance. For example, Amazon Linux 2,
	// Ubuntu 18, or Microsoft Windows Server 2019.
	OsVersion *string `locationName:"osVersion" min:"1" type:"string"`

	// The output resources produced when creating this image.
	OutputResources *OutputResources `locationName:"outputResources" type:"structure"`

	// The platform of the image.
	Platform Platform `locationName:"platform" type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the image pipeline that created this image.
	SourcePipelineArn *string `locationName:"sourcePipelineArn" type:"string"`

	// The name of the image pipeline that created this image.
	SourcePipelineName *string `locationName:"sourcePipelineName" type:"string"`

	// The state of the image.
	State *ImageState `locationName:"state" type:"structure"`

	// The tags of the image.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The semantic version of the image.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s Image) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Image) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DistributionConfiguration != nil {
		v := s.DistributionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "distributionConfiguration", v, metadata)
	}
	if s.EnhancedImageMetadataEnabled != nil {
		v := *s.EnhancedImageMetadataEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enhancedImageMetadataEnabled", protocol.BoolValue(v), metadata)
	}
	if s.ImageRecipe != nil {
		v := s.ImageRecipe

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "imageRecipe", v, metadata)
	}
	if s.ImageTestsConfiguration != nil {
		v := s.ImageTestsConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "imageTestsConfiguration", v, metadata)
	}
	if s.InfrastructureConfiguration != nil {
		v := s.InfrastructureConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "infrastructureConfiguration", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OsVersion != nil {
		v := *s.OsVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "osVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutputResources != nil {
		v := s.OutputResources

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "outputResources", v, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.SourcePipelineArn != nil {
		v := *s.SourcePipelineArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourcePipelineArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourcePipelineName != nil {
		v := *s.SourcePipelineName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourcePipelineName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "state", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details of an image pipeline.
type ImagePipeline struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image pipeline.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which this image pipeline was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The date on which this image pipeline was last run.
	DateLastRun *string `locationName:"dateLastRun" type:"string"`

	// The date on which this image pipeline will next be run.
	DateNextRun *string `locationName:"dateNextRun" type:"string"`

	// The date on which this image pipeline was last updated.
	DateUpdated *string `locationName:"dateUpdated" type:"string"`

	// The description of the image pipeline.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the distribution configuration associated
	// with this image pipeline.
	DistributionConfigurationArn *string `locationName:"distributionConfigurationArn" type:"string"`

	// Collects additional information about the image being created, including
	// the operating system (OS) version and package list. This information is used
	// to enhance the overall experience of using EC2 Image Builder. Enabled by
	// default.
	EnhancedImageMetadataEnabled *bool `locationName:"enhancedImageMetadataEnabled" type:"boolean"`

	// The Amazon Resource Name (ARN) of the image recipe associated with this image
	// pipeline.
	ImageRecipeArn *string `locationName:"imageRecipeArn" type:"string"`

	// The image tests configuration of the image pipeline.
	ImageTestsConfiguration *ImageTestsConfiguration `locationName:"imageTestsConfiguration" type:"structure"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration associated
	// with this image pipeline.
	InfrastructureConfigurationArn *string `locationName:"infrastructureConfigurationArn" type:"string"`

	// The name of the image pipeline.
	Name *string `locationName:"name" type:"string"`

	// The platform of the image pipeline.
	Platform Platform `locationName:"platform" type:"string" enum:"true"`

	// The schedule of the image pipeline.
	Schedule *Schedule `locationName:"schedule" type:"structure"`

	// The status of the image pipeline.
	Status PipelineStatus `locationName:"status" type:"string" enum:"true"`

	// The tags of this image pipeline.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s ImagePipeline) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImagePipeline) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateLastRun != nil {
		v := *s.DateLastRun

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateLastRun", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateNextRun != nil {
		v := *s.DateNextRun

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateNextRun", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateUpdated != nil {
		v := *s.DateUpdated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateUpdated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DistributionConfigurationArn != nil {
		v := *s.DistributionConfigurationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "distributionConfigurationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnhancedImageMetadataEnabled != nil {
		v := *s.EnhancedImageMetadataEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enhancedImageMetadataEnabled", protocol.BoolValue(v), metadata)
	}
	if s.ImageRecipeArn != nil {
		v := *s.ImageRecipeArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageRecipeArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageTestsConfiguration != nil {
		v := s.ImageTestsConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "imageTestsConfiguration", v, metadata)
	}
	if s.InfrastructureConfigurationArn != nil {
		v := *s.InfrastructureConfigurationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "infrastructureConfigurationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "schedule", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// An image recipe.
type ImageRecipe struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe.
	Arn *string `locationName:"arn" type:"string"`

	// The block device mappings to apply when creating images from this recipe.
	BlockDeviceMappings []InstanceBlockDeviceMapping `locationName:"blockDeviceMappings" type:"list"`

	// The components of the image recipe.
	Components []ComponentConfiguration `locationName:"components" min:"1" type:"list"`

	// The date on which this image recipe was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The description of the image recipe.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the image recipe.
	Name *string `locationName:"name" type:"string"`

	// The owner of the image recipe.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The parent image of the image recipe.
	ParentImage *string `locationName:"parentImage" min:"1" type:"string"`

	// The platform of the image recipe.
	Platform Platform `locationName:"platform" type:"string" enum:"true"`

	// The tags of the image recipe.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The version of the image recipe.
	Version *string `locationName:"version" type:"string"`

	// The working directory to be used during build and test workflows.
	WorkingDirectory *string `locationName:"workingDirectory" min:"1" type:"string"`
}

// String returns the string representation
func (s ImageRecipe) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImageRecipe) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BlockDeviceMappings != nil {
		v := s.BlockDeviceMappings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "blockDeviceMappings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Components != nil {
		v := s.Components

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "components", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentImage != nil {
		v := *s.ParentImage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "parentImage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WorkingDirectory != nil {
		v := *s.WorkingDirectory

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "workingDirectory", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A summary of an image recipe.
type ImageRecipeSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image recipe.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which this image recipe was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The name of the image recipe.
	Name *string `locationName:"name" type:"string"`

	// The owner of the image recipe.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The parent image of the image recipe.
	ParentImage *string `locationName:"parentImage" min:"1" type:"string"`

	// The platform of the image recipe.
	Platform Platform `locationName:"platform" type:"string" enum:"true"`

	// The tags of the image recipe.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s ImageRecipeSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImageRecipeSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentImage != nil {
		v := *s.ParentImage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "parentImage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Image state shows the image status and the reason for that status.
type ImageState struct {
	_ struct{} `type:"structure"`

	// The reason for the image's status.
	Reason *string `locationName:"reason" min:"1" type:"string"`

	// The status of the image.
	Status ImageStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s ImageState) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImageState) MarshalFields(e protocol.FieldEncoder) error {
	if s.Reason != nil {
		v := *s.Reason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// An image summary.
type ImageSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which this image was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The name of the image.
	Name *string `locationName:"name" type:"string"`

	// The operating system version of the instance. For example, Amazon Linux 2,
	// Ubuntu 18, or Microsoft Windows Server 2019.
	OsVersion *string `locationName:"osVersion" min:"1" type:"string"`

	// The output resources produced when creating this image.
	OutputResources *OutputResources `locationName:"outputResources" type:"structure"`

	// The owner of the image.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The platform of the image.
	Platform Platform `locationName:"platform" type:"string" enum:"true"`

	// The state of the image.
	State *ImageState `locationName:"state" type:"structure"`

	// The tags of the image.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The version of the image.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ImageSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImageSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OsVersion != nil {
		v := *s.OsVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "osVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutputResources != nil {
		v := s.OutputResources

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "outputResources", v, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "state", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Image tests configuration.
type ImageTestsConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines if tests should be executed when building this image.
	ImageTestsEnabled *bool `locationName:"imageTestsEnabled" type:"boolean"`

	// The maximum time in minutes that tests are permitted to run.
	TimeoutMinutes *int64 `locationName:"timeoutMinutes" min:"60" type:"integer"`
}

// String returns the string representation
func (s ImageTestsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImageTestsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ImageTestsConfiguration"}
	if s.TimeoutMinutes != nil && *s.TimeoutMinutes < 60 {
		invalidParams.Add(aws.NewErrParamMinValue("TimeoutMinutes", 60))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImageTestsConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ImageTestsEnabled != nil {
		v := *s.ImageTestsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageTestsEnabled", protocol.BoolValue(v), metadata)
	}
	if s.TimeoutMinutes != nil {
		v := *s.TimeoutMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeoutMinutes", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An image semantic version.
type ImageVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image semantic version.
	Arn *string `locationName:"arn" type:"string"`

	// The date at which this image semantic version was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The name of the image semantic version.
	Name *string `locationName:"name" type:"string"`

	// The operating system version of the instance. For example, Amazon Linux 2,
	// Ubuntu 18, or Microsoft Windows Server 2019.
	OsVersion *string `locationName:"osVersion" min:"1" type:"string"`

	// The owner of the image semantic version.
	Owner *string `locationName:"owner" min:"1" type:"string"`

	// The platform of the image semantic version.
	Platform Platform `locationName:"platform" type:"string" enum:"true"`

	// The semantic version of the image semantic version.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ImageVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImageVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OsVersion != nil {
		v := *s.OsVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "osVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := *s.Owner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "owner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Details of the infrastructure configuration.
type InfrastructureConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which the infrastructure configuration was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The date on which the infrastructure configuration was last updated.
	DateUpdated *string `locationName:"dateUpdated" type:"string"`

	// The description of the infrastructure configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The instance profile of the infrastructure configuration.
	InstanceProfileName *string `locationName:"instanceProfileName" min:"1" type:"string"`

	// The instance types of the infrastructure configuration.
	InstanceTypes []string `locationName:"instanceTypes" type:"list"`

	// The EC2 key pair of the infrastructure configuration.
	KeyPair *string `locationName:"keyPair" min:"1" type:"string"`

	// The logging configuration of the infrastructure configuration.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of the infrastructure configuration.
	Name *string `locationName:"name" type:"string"`

	// The tags attached to the resource created by Image Builder.
	ResourceTags map[string]string `locationName:"resourceTags" min:"1" type:"map"`

	// The security group IDs of the infrastructure configuration.
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list"`

	// The SNS topic Amazon Resource Name (ARN) of the infrastructure configuration.
	SnsTopicArn *string `locationName:"snsTopicArn" min:"1" type:"string"`

	// The subnet ID of the infrastructure configuration.
	SubnetId *string `locationName:"subnetId" min:"1" type:"string"`

	// The tags of the infrastructure configuration.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The terminate instance on failure configuration of the infrastructure configuration.
	TerminateInstanceOnFailure *bool `locationName:"terminateInstanceOnFailure" type:"boolean"`
}

// String returns the string representation
func (s InfrastructureConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InfrastructureConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateUpdated != nil {
		v := *s.DateUpdated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateUpdated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceProfileName != nil {
		v := *s.InstanceProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceTypes != nil {
		v := s.InstanceTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "instanceTypes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.KeyPair != nil {
		v := *s.KeyPair

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyPair", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Logging != nil {
		v := s.Logging

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "logging", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceTags != nil {
		v := s.ResourceTags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "resourceTags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SnsTopicArn != nil {
		v := *s.SnsTopicArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "snsTopicArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SubnetId != nil {
		v := *s.SubnetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "subnetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TerminateInstanceOnFailure != nil {
		v := *s.TerminateInstanceOnFailure

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "terminateInstanceOnFailure", protocol.BoolValue(v), metadata)
	}
	return nil
}

// The infrastructure used when building EC2 AMIs.
type InfrastructureConfigurationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the infrastructure configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The date on which the infrastructure configuration was created.
	DateCreated *string `locationName:"dateCreated" type:"string"`

	// The date on which the infrastructure configuration was last updated.
	DateUpdated *string `locationName:"dateUpdated" type:"string"`

	// The description of the infrastructure configuration.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the infrastructure configuration.
	Name *string `locationName:"name" type:"string"`

	// The tags attached to the image created by Image Builder.
	ResourceTags map[string]string `locationName:"resourceTags" min:"1" type:"map"`

	// The tags of the infrastructure configuration.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s InfrastructureConfigurationSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InfrastructureConfigurationSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateCreated != nil {
		v := *s.DateCreated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateCreated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DateUpdated != nil {
		v := *s.DateUpdated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dateUpdated", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceTags != nil {
		v := s.ResourceTags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "resourceTags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Defines block device mappings for the instance used to configure your image.
type InstanceBlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device to which these mappings apply.
	DeviceName *string `locationName:"deviceName" min:"1" type:"string"`

	// Use to manage Amazon EBS-specific configuration for this mapping.
	Ebs *EbsInstanceBlockDeviceSpecification `locationName:"ebs" type:"structure"`

	// Use to remove a mapping from the parent image.
	NoDevice *string `locationName:"noDevice" type:"string"`

	// Use to manage instance ephemeral devices.
	VirtualName *string `locationName:"virtualName" min:"1" type:"string"`
}

// String returns the string representation
func (s InstanceBlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceBlockDeviceMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InstanceBlockDeviceMapping"}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeviceName", 1))
	}
	if s.VirtualName != nil && len(*s.VirtualName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualName", 1))
	}
	if s.Ebs != nil {
		if err := s.Ebs.Validate(); err != nil {
			invalidParams.AddNested("Ebs", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InstanceBlockDeviceMapping) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeviceName != nil {
		v := *s.DeviceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deviceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Ebs != nil {
		v := s.Ebs

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ebs", v, metadata)
	}
	if s.NoDevice != nil {
		v := *s.NoDevice

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "noDevice", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualName != nil {
		v := *s.VirtualName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the configuration for a launch permission. The launch permission
// modification request is sent to the EC2 ModifyImageAttribute (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html)
// API on behalf of the user for each Region they have selected to distribute
// the AMI. To make an AMI public, set the launch permission authorized accounts
// to all. See the examples for making an AMI public at EC2 ModifyImageAttribute
// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyImageAttribute.html).
type LaunchPermissionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	UserGroups []string `locationName:"userGroups" type:"list"`

	// The AWS account ID.
	UserIds []string `locationName:"userIds" type:"list"`
}

// String returns the string representation
func (s LaunchPermissionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LaunchPermissionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.UserGroups != nil {
		v := s.UserGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "userGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.UserIds != nil {
		v := s.UserIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "userIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Logging configuration defines where Image Builder uploads your logs.
type Logging struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 logging configuration.
	S3Logs *S3Logs `locationName:"s3Logs" type:"structure"`
}

// String returns the string representation
func (s Logging) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Logging) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Logging"}
	if s.S3Logs != nil {
		if err := s.S3Logs.Validate(); err != nil {
			invalidParams.AddNested("S3Logs", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Logging) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3Logs != nil {
		v := s.S3Logs

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3Logs", v, metadata)
	}
	return nil
}

// The resources produced by this image.
type OutputResources struct {
	_ struct{} `type:"structure"`

	// The EC2 AMIs created by this image.
	Amis []Ami `locationName:"amis" type:"list"`
}

// String returns the string representation
func (s OutputResources) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputResources) MarshalFields(e protocol.FieldEncoder) error {
	if s.Amis != nil {
		v := s.Amis

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "amis", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Amazon S3 logging configuration.
type S3Logs struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket in which to store the logs.
	S3BucketName *string `locationName:"s3BucketName" min:"1" type:"string"`

	// The Amazon S3 path in which to store the logs.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" min:"1" type:"string"`
}

// String returns the string representation
func (s S3Logs) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Logs) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Logs"}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3BucketName", 1))
	}
	if s.S3KeyPrefix != nil && len(*s.S3KeyPrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S3KeyPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3Logs) MarshalFields(e protocol.FieldEncoder) error {
	if s.S3BucketName != nil {
		v := *s.S3BucketName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3BucketName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3KeyPrefix != nil {
		v := *s.S3KeyPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "s3KeyPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A schedule configures how often and when a pipeline will automatically create
// a new image.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The condition configures when the pipeline should trigger a new image build.
	// When the pipelineExecutionStartCondition is set to EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE,
	// EC2 Image Builder will build a new image only when there are known changes
	// pending. When it is set to EXPRESSION_MATCH_ONLY, it will build a new image
	// every time the CRON expression matches the current time.
	PipelineExecutionStartCondition PipelineExecutionStartCondition `locationName:"pipelineExecutionStartCondition" type:"string" enum:"true"`

	// The expression determines how often EC2 Image Builder evaluates your pipelineExecutionStartCondition.
	ScheduleExpression *string `locationName:"scheduleExpression" min:"1" type:"string"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Schedule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Schedule"}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ScheduleExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Schedule) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.PipelineExecutionStartCondition) > 0 {
		v := s.PipelineExecutionStartCondition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelineExecutionStartCondition", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ScheduleExpression != nil {
		v := *s.ScheduleExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scheduleExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
