// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package imagebuilder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type PutImagePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image that this policy should be applied
	// to.
	//
	// ImageArn is a required field
	ImageArn *string `locationName:"imageArn" type:"string" required:"true"`

	// The policy to apply.
	//
	// Policy is a required field
	Policy *string `locationName:"policy" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutImagePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutImagePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutImagePolicyInput"}

	if s.ImageArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ImageArn"))
	}

	if s.Policy == nil {
		invalidParams.Add(aws.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutImagePolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ImageArn != nil {
		v := *s.ImageArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "policy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type PutImagePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the image that this policy was applied
	// to.
	ImageArn *string `locationName:"imageArn" type:"string"`

	// The request ID that uniquely identifies this request.
	RequestId *string `locationName:"requestId" min:"1" type:"string"`
}

// String returns the string representation
func (s PutImagePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutImagePolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ImageArn != nil {
		v := *s.ImageArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "requestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opPutImagePolicy = "PutImagePolicy"

// PutImagePolicyRequest returns a request value for making API operation for
// EC2 Image Builder.
//
// Applies a policy to an image. We recommend that you call the RAM API CreateResourceShare
// (https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html)
// to share resources. If you call the Image Builder API PutImagePolicy, you
// must also call the RAM API PromoteResourceShareCreatedFromPolicy (https://docs.aws.amazon.com/ram/latest/APIReference/API_PromoteResourceShareCreatedFromPolicy.html)
// in order for the resource to be visible to all principals with whom the resource
// is shared.
//
//    // Example sending a request using PutImagePolicyRequest.
//    req := client.PutImagePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PutImagePolicy
func (c *Client) PutImagePolicyRequest(input *PutImagePolicyInput) PutImagePolicyRequest {
	op := &aws.Operation{
		Name:       opPutImagePolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/PutImagePolicy",
	}

	if input == nil {
		input = &PutImagePolicyInput{}
	}

	req := c.newRequest(op, input, &PutImagePolicyOutput{})

	return PutImagePolicyRequest{Request: req, Input: input, Copy: c.PutImagePolicyRequest}
}

// PutImagePolicyRequest is the request type for the
// PutImagePolicy API operation.
type PutImagePolicyRequest struct {
	*aws.Request
	Input *PutImagePolicyInput
	Copy  func(*PutImagePolicyInput) PutImagePolicyRequest
}

// Send marshals and sends the PutImagePolicy API request.
func (r PutImagePolicyRequest) Send(ctx context.Context) (*PutImagePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutImagePolicyResponse{
		PutImagePolicyOutput: r.Request.Data.(*PutImagePolicyOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutImagePolicyResponse is the response type for the
// PutImagePolicy API operation.
type PutImagePolicyResponse struct {
	*PutImagePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutImagePolicy request.
func (r *PutImagePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
