// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetServiceLastAccessedDetailsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the request generated by the GenerateServiceLastAccessedDetails
	// operation. The JobId returned by GenerateServiceLastAccessedDetail must be
	// used by the same role within a session, or by the same user when used to
	// call GetServiceLastAccessedDetail.
	//
	// JobId is a required field
	JobId *string `min:"36" type:"string" required:"true"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, the number of items defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true, and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GetServiceLastAccessedDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceLastAccessedDetailsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetServiceLastAccessedDetailsInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 36))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetServiceLastAccessedDetailsOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains details about the reason the operation failed.
	Error *ErrorDetails `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all your results.
	IsTruncated *bool `type:"boolean"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the generated report job was completed or failed.
	//
	// This field is null if the job is still in progress, as indicated by a job
	// status value of IN_PROGRESS.
	//
	// JobCompletionDate is a required field
	JobCompletionDate *time.Time `type:"timestamp" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the report job was created.
	//
	// JobCreationDate is a required field
	JobCreationDate *time.Time `type:"timestamp" required:"true"`

	// The status of the job.
	//
	// JobStatus is a required field
	JobStatus JobStatusType `type:"string" required:"true" enum:"true"`

	// The type of job. Service jobs return information about when each service
	// was last accessed. Action jobs also include information about when tracked
	// actions within the service were last accessed.
	JobType AccessAdvisorUsageGranularityType `type:"string" enum:"true"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `type:"string"`

	// A ServiceLastAccessed object that contains details about the most recent
	// attempt to access the service.
	//
	// ServicesLastAccessed is a required field
	ServicesLastAccessed []ServiceLastAccessed `type:"list" required:"true"`
}

// String returns the string representation
func (s GetServiceLastAccessedDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetServiceLastAccessedDetails = "GetServiceLastAccessedDetails"

// GetServiceLastAccessedDetailsRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Retrieves a service last accessed report that was created using the GenerateServiceLastAccessedDetails
// operation. You can use the JobId parameter in GetServiceLastAccessedDetails
// to retrieve the status of your report job. When the report is complete, you
// can retrieve the generated report. The report includes a list of AWS services
// that the resource (user, group, role, or managed policy) can access.
//
// Service last accessed data does not use other policy types when determining
// whether a resource could access a service. These other policy types include
// resource-based policies, access control lists, AWS Organizations policies,
// IAM permissions boundaries, and AWS STS assume role policies. It only applies
// permissions policy logic. For more about the evaluation of policy types,
// see Evaluating Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics)
// in the IAM User Guide.
//
// For each service that the resource could access using permissions policies,
// the operation returns details about the most recent access attempt. If there
// was no attempt, the service is listed without details about the most recent
// attempt to access the service. If the operation fails, the GetServiceLastAccessedDetails
// operation returns the reason that it failed.
//
// The GetServiceLastAccessedDetails operation returns a list of services. This
// list includes the number of entities that have attempted to access the service
// and the date and time of the last attempt. It also returns the ARN of the
// following entity, depending on the resource ARN that you used to generate
// the report:
//
//    * User – Returns the user ARN that you used to generate the report
//
//    * Group – Returns the ARN of the group member (user) that last attempted
//    to access the service
//
//    * Role – Returns the role ARN that you used to generate the report
//
//    * Policy – Returns the ARN of the user or role that last used the policy
//    to attempt to access the service
//
// By default, the list is sorted by service namespace.
//
// If you specified ACTION_LEVEL granularity when you generated the report,
// this operation returns service and action last accessed data. This includes
// the most recent access attempt for each tracked action within a service.
// Otherwise, this operation returns only service data.
//
// For more information about service and action last accessed data, see Reducing
// Permissions Using Service Last Accessed Data (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html)
// in the IAM User Guide.
//
//    // Example sending a request using GetServiceLastAccessedDetailsRequest.
//    req := client.GetServiceLastAccessedDetailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetails
func (c *Client) GetServiceLastAccessedDetailsRequest(input *GetServiceLastAccessedDetailsInput) GetServiceLastAccessedDetailsRequest {
	op := &aws.Operation{
		Name:       opGetServiceLastAccessedDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceLastAccessedDetailsInput{}
	}

	req := c.newRequest(op, input, &GetServiceLastAccessedDetailsOutput{})

	return GetServiceLastAccessedDetailsRequest{Request: req, Input: input, Copy: c.GetServiceLastAccessedDetailsRequest}
}

// GetServiceLastAccessedDetailsRequest is the request type for the
// GetServiceLastAccessedDetails API operation.
type GetServiceLastAccessedDetailsRequest struct {
	*aws.Request
	Input *GetServiceLastAccessedDetailsInput
	Copy  func(*GetServiceLastAccessedDetailsInput) GetServiceLastAccessedDetailsRequest
}

// Send marshals and sends the GetServiceLastAccessedDetails API request.
func (r GetServiceLastAccessedDetailsRequest) Send(ctx context.Context) (*GetServiceLastAccessedDetailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetServiceLastAccessedDetailsResponse{
		GetServiceLastAccessedDetailsOutput: r.Request.Data.(*GetServiceLastAccessedDetailsOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetServiceLastAccessedDetailsResponse is the response type for the
// GetServiceLastAccessedDetails API operation.
type GetServiceLastAccessedDetailsResponse struct {
	*GetServiceLastAccessedDetailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetServiceLastAccessedDetails request.
func (r *GetServiceLastAccessedDetailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
