// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains information on the current access control policies for the bucket.
type AccessControlList struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether public read access for the bucket is enabled
	// through an Access Control List (ACL).
	AllowsPublicReadAccess *bool `locationName:"allowsPublicReadAccess" type:"boolean"`

	// A value that indicates whether public write access for the bucket is enabled
	// through an Access Control List (ACL).
	AllowsPublicWriteAccess *bool `locationName:"allowsPublicWriteAccess" type:"boolean"`
}

// String returns the string representation
func (s AccessControlList) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessControlList) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowsPublicReadAccess != nil {
		v := *s.AllowsPublicReadAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowsPublicReadAccess", protocol.BoolValue(v), metadata)
	}
	if s.AllowsPublicWriteAccess != nil {
		v := *s.AllowsPublicWriteAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowsPublicWriteAccess", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Contains information about the access keys.
type AccessKeyDetails struct {
	_ struct{} `type:"structure"`

	// The access key ID of the user.
	AccessKeyId *string `locationName:"accessKeyId" type:"string"`

	// The principal ID of the user.
	PrincipalId *string `locationName:"principalId" type:"string"`

	// The name of the user.
	UserName *string `locationName:"userName" type:"string"`

	// The type of the user.
	UserType *string `locationName:"userType" type:"string"`
}

// String returns the string representation
func (s AccessKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessKeyDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessKeyId != nil {
		v := *s.AccessKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "principalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserName != nil {
		v := *s.UserName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserType != nil {
		v := *s.UserType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the account.
type AccountDetail struct {
	_ struct{} `type:"structure"`

	// The member account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The email address of the member account.
	//
	// Email is a required field
	Email *string `locationName:"email" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AccountDetail) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountDetail) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccountDetail"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AccountId", 12))
	}

	if s.Email == nil {
		invalidParams.Add(aws.NewErrParamRequired("Email"))
	}
	if s.Email != nil && len(*s.Email) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Email", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the account level permissions on the S3 bucket.
type AccountLevelPermissions struct {
	_ struct{} `type:"structure"`

	// Describes the S3 Block Public Access settings of the bucket's parent account.
	BlockPublicAccess *BlockPublicAccess `locationName:"blockPublicAccess" type:"structure"`
}

// String returns the string representation
func (s AccountLevelPermissions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountLevelPermissions) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlockPublicAccess != nil {
		v := s.BlockPublicAccess

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "blockPublicAccess", v, metadata)
	}
	return nil
}

// Contains information about actions.
type Action struct {
	_ struct{} `type:"structure"`

	// The GuardDuty finding activity type.
	ActionType *string `locationName:"actionType" type:"string"`

	// Information about the AWS_API_CALL action described in this finding.
	AwsApiCallAction *AwsApiCallAction `locationName:"awsApiCallAction" type:"structure"`

	// Information about the DNS_REQUEST action described in this finding.
	DnsRequestAction *DnsRequestAction `locationName:"dnsRequestAction" type:"structure"`

	// Information about the NETWORK_CONNECTION action described in this finding.
	NetworkConnectionAction *NetworkConnectionAction `locationName:"networkConnectionAction" type:"structure"`

	// Information about the PORT_PROBE action described in this finding.
	PortProbeAction *PortProbeAction `locationName:"portProbeAction" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Action) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActionType != nil {
		v := *s.ActionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "actionType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsApiCallAction != nil {
		v := s.AwsApiCallAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "awsApiCallAction", v, metadata)
	}
	if s.DnsRequestAction != nil {
		v := s.DnsRequestAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dnsRequestAction", v, metadata)
	}
	if s.NetworkConnectionAction != nil {
		v := s.NetworkConnectionAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "networkConnectionAction", v, metadata)
	}
	if s.PortProbeAction != nil {
		v := s.PortProbeAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portProbeAction", v, metadata)
	}
	return nil
}

// The account within the organization specified as the GuardDuty delegated
// administrator.
type AdminAccount struct {
	_ struct{} `type:"structure"`

	// The AWS account ID for the account.
	AdminAccountId *string `locationName:"adminAccountId" type:"string"`

	// Indicates whether the account is enabled as the delegated administrator.
	AdminStatus AdminStatus `locationName:"adminStatus" min:"1" type:"string" enum:"true"`
}

// String returns the string representation
func (s AdminAccount) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AdminAccount) MarshalFields(e protocol.FieldEncoder) error {
	if s.AdminAccountId != nil {
		v := *s.AdminAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adminAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AdminStatus) > 0 {
		v := s.AdminStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "adminStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains information about the API operation.
type AwsApiCallAction struct {
	_ struct{} `type:"structure"`

	// The AWS API name.
	Api *string `locationName:"api" type:"string"`

	// The AWS API caller type.
	CallerType *string `locationName:"callerType" type:"string"`

	// The domain information for the AWS API call.
	DomainDetails *DomainDetails `locationName:"domainDetails" type:"structure"`

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`

	// The AWS service name whose API was invoked.
	ServiceName *string `locationName:"serviceName" type:"string"`
}

// String returns the string representation
func (s AwsApiCallAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsApiCallAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Api != nil {
		v := *s.Api

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "api", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CallerType != nil {
		v := *s.CallerType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "callerType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainDetails != nil {
		v := s.DomainDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "domainDetails", v, metadata)
	}
	if s.RemoteIpDetails != nil {
		v := s.RemoteIpDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remoteIpDetails", v, metadata)
	}
	if s.ServiceName != nil {
		v := *s.ServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information on how the bucker owner's S3 Block Public Access settings
// are being applied to the S3 bucket. See S3 Block Public Access (https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
// for more information.
type BlockPublicAccess struct {
	_ struct{} `type:"structure"`

	// Indicates if S3 Block Public Access is set to BlockPublicAcls.
	BlockPublicAcls *bool `locationName:"blockPublicAcls" type:"boolean"`

	// Indicates if S3 Block Public Access is set to BlockPublicPolicy.
	BlockPublicPolicy *bool `locationName:"blockPublicPolicy" type:"boolean"`

	// Indicates if S3 Block Public Access is set to IgnorePublicAcls.
	IgnorePublicAcls *bool `locationName:"ignorePublicAcls" type:"boolean"`

	// Indicates if S3 Block Public Access is set to RestrictPublicBuckets.
	RestrictPublicBuckets *bool `locationName:"restrictPublicBuckets" type:"boolean"`
}

// String returns the string representation
func (s BlockPublicAccess) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BlockPublicAccess) MarshalFields(e protocol.FieldEncoder) error {
	if s.BlockPublicAcls != nil {
		v := *s.BlockPublicAcls

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blockPublicAcls", protocol.BoolValue(v), metadata)
	}
	if s.BlockPublicPolicy != nil {
		v := *s.BlockPublicPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blockPublicPolicy", protocol.BoolValue(v), metadata)
	}
	if s.IgnorePublicAcls != nil {
		v := *s.IgnorePublicAcls

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ignorePublicAcls", protocol.BoolValue(v), metadata)
	}
	if s.RestrictPublicBuckets != nil {
		v := *s.RestrictPublicBuckets

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "restrictPublicBuckets", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Contains information about the bucket level permissions for the S3 bucket.
type BucketLevelPermissions struct {
	_ struct{} `type:"structure"`

	// Contains information on how Access Control Policies are applied to the bucket.
	AccessControlList *AccessControlList `locationName:"accessControlList" type:"structure"`

	// Contains information on which account level S3 Block Public Access settings
	// are applied to the S3 bucket.
	BlockPublicAccess *BlockPublicAccess `locationName:"blockPublicAccess" type:"structure"`

	// Contains information on the bucket policies for the S3 bucket.
	BucketPolicy *BucketPolicy `locationName:"bucketPolicy" type:"structure"`
}

// String returns the string representation
func (s BucketLevelPermissions) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketLevelPermissions) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessControlList != nil {
		v := s.AccessControlList

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessControlList", v, metadata)
	}
	if s.BlockPublicAccess != nil {
		v := s.BlockPublicAccess

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "blockPublicAccess", v, metadata)
	}
	if s.BucketPolicy != nil {
		v := s.BucketPolicy

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "bucketPolicy", v, metadata)
	}
	return nil
}

// Contains information on the current bucket policies for the S3 bucket.
type BucketPolicy struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether public read access for the bucket is enabled
	// through a bucket policy.
	AllowsPublicReadAccess *bool `locationName:"allowsPublicReadAccess" type:"boolean"`

	// A value that indicates whether public write access for the bucket is enabled
	// through a bucket policy.
	AllowsPublicWriteAccess *bool `locationName:"allowsPublicWriteAccess" type:"boolean"`
}

// String returns the string representation
func (s BucketPolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowsPublicReadAccess != nil {
		v := *s.AllowsPublicReadAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowsPublicReadAccess", protocol.BoolValue(v), metadata)
	}
	if s.AllowsPublicWriteAccess != nil {
		v := *s.AllowsPublicWriteAccess

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowsPublicWriteAccess", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Contains information about the city associated with the IP address.
type City struct {
	_ struct{} `type:"structure"`

	// The city name of the remote IP address.
	CityName *string `locationName:"cityName" type:"string"`
}

// String returns the string representation
func (s City) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s City) MarshalFields(e protocol.FieldEncoder) error {
	if s.CityName != nil {
		v := *s.CityName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cityName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the condition.
type Condition struct {
	_ struct{} `type:"structure"`

	// Represents the equal condition to be applied to a single field when querying
	// for findings.
	Eq []string `locationName:"eq" deprecated:"true" type:"list"`

	// Represents an equal condition to be applied to a single field when querying
	// for findings.
	Equals []string `locationName:"equals" type:"list"`

	// Represents a greater than condition to be applied to a single field when
	// querying for findings.
	GreaterThan *int64 `locationName:"greaterThan" type:"long"`

	// Represents a greater than or equal condition to be applied to a single field
	// when querying for findings.
	GreaterThanOrEqual *int64 `locationName:"greaterThanOrEqual" type:"long"`

	// Represents a greater than condition to be applied to a single field when
	// querying for findings.
	Gt *int64 `locationName:"gt" deprecated:"true" type:"integer"`

	// Represents a greater than or equal condition to be applied to a single field
	// when querying for findings.
	Gte *int64 `locationName:"gte" deprecated:"true" type:"integer"`

	// Represents a less than condition to be applied to a single field when querying
	// for findings.
	LessThan *int64 `locationName:"lessThan" type:"long"`

	// Represents a less than or equal condition to be applied to a single field
	// when querying for findings.
	LessThanOrEqual *int64 `locationName:"lessThanOrEqual" type:"long"`

	// Represents a less than condition to be applied to a single field when querying
	// for findings.
	Lt *int64 `locationName:"lt" deprecated:"true" type:"integer"`

	// Represents a less than or equal condition to be applied to a single field
	// when querying for findings.
	Lte *int64 `locationName:"lte" deprecated:"true" type:"integer"`

	// Represents the not equal condition to be applied to a single field when querying
	// for findings.
	Neq []string `locationName:"neq" deprecated:"true" type:"list"`

	// Represents a not equal condition to be applied to a single field when querying
	// for findings.
	NotEquals []string `locationName:"notEquals" type:"list"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Condition) MarshalFields(e protocol.FieldEncoder) error {
	if s.Eq != nil {
		v := s.Eq

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "eq", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Equals != nil {
		v := s.Equals

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "equals", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.GreaterThan != nil {
		v := *s.GreaterThan

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "greaterThan", protocol.Int64Value(v), metadata)
	}
	if s.GreaterThanOrEqual != nil {
		v := *s.GreaterThanOrEqual

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "greaterThanOrEqual", protocol.Int64Value(v), metadata)
	}
	if s.Gt != nil {
		v := *s.Gt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gt", protocol.Int64Value(v), metadata)
	}
	if s.Gte != nil {
		v := *s.Gte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gte", protocol.Int64Value(v), metadata)
	}
	if s.LessThan != nil {
		v := *s.LessThan

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lessThan", protocol.Int64Value(v), metadata)
	}
	if s.LessThanOrEqual != nil {
		v := *s.LessThanOrEqual

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lessThanOrEqual", protocol.Int64Value(v), metadata)
	}
	if s.Lt != nil {
		v := *s.Lt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lt", protocol.Int64Value(v), metadata)
	}
	if s.Lte != nil {
		v := *s.Lte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lte", protocol.Int64Value(v), metadata)
	}
	if s.Neq != nil {
		v := s.Neq

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "neq", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NotEquals != nil {
		v := s.NotEquals

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "notEquals", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Contains information about the country where the remote IP address is located.
type Country struct {
	_ struct{} `type:"structure"`

	// The country code of the remote IP address.
	CountryCode *string `locationName:"countryCode" type:"string"`

	// The country name of the remote IP address.
	CountryName *string `locationName:"countryName" type:"string"`
}

// String returns the string representation
func (s Country) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Country) MarshalFields(e protocol.FieldEncoder) error {
	if s.CountryCode != nil {
		v := *s.CountryCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "countryCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CountryName != nil {
		v := *s.CountryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "countryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information on the server side encryption method used in the S3
// bucket. See S3 Server-Side Encryption (https://docs.aws.amazon.com/AmazonS3/atest/dev/serv-side-encryption.html)
// for more information.
type DefaultServerSideEncryption struct {
	_ struct{} `type:"structure"`

	// The type of encryption used for objects within the S3 bucket.
	EncryptionType *string `locationName:"encryptionType" type:"string"`

	// The Amazon Resource Name (ARN) of the KMS encryption key. Only available
	// if the bucket EncryptionType is aws:kms.
	KmsMasterKeyArn *string `locationName:"kmsMasterKeyArn" type:"string"`
}

// String returns the string representation
func (s DefaultServerSideEncryption) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefaultServerSideEncryption) MarshalFields(e protocol.FieldEncoder) error {
	if s.EncryptionType != nil {
		v := *s.EncryptionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "encryptionType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KmsMasterKeyArn != nil {
		v := *s.KmsMasterKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kmsMasterKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the publishing destination, including the ID,
// type, and status.
type Destination struct {
	_ struct{} `type:"structure"`

	// The unique ID of the publishing destination.
	//
	// DestinationId is a required field
	DestinationId *string `locationName:"destinationId" type:"string" required:"true"`

	// The type of resource used for the publishing destination. Currently, only
	// Amazon S3 buckets are supported.
	//
	// DestinationType is a required field
	DestinationType DestinationType `locationName:"destinationType" min:"1" type:"string" required:"true" enum:"true"`

	// The status of the publishing destination.
	//
	// Status is a required field
	Status PublishingStatus `locationName:"status" min:"1" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Destination) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationId != nil {
		v := *s.DestinationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destinationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DestinationType) > 0 {
		v := s.DestinationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destinationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains the Amazon Resource Name (ARN) of the resource to publish to, such
// as an S3 bucket, and the ARN of the KMS key to use to encrypt published findings.
type DestinationProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to publish to.
	DestinationArn *string `locationName:"destinationArn" type:"string"`

	// The ARN of the KMS key to use for encryption.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`
}

// String returns the string representation
func (s DestinationProperties) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DestinationProperties) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationArn != nil {
		v := *s.DestinationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destinationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KmsKeyArn != nil {
		v := *s.KmsKeyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "kmsKeyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the DNS_REQUEST action described in this finding.
type DnsRequestAction struct {
	_ struct{} `type:"structure"`

	// The domain information for the API request.
	Domain *string `locationName:"domain" type:"string"`
}

// String returns the string representation
func (s DnsRequestAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DnsRequestAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the domain.
type DomainDetails struct {
	_ struct{} `type:"structure"`

	// The domain information for the AWS API call.
	Domain *string `locationName:"domain" type:"string"`
}

// String returns the string representation
func (s DomainDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the reason that the finding was generated.
type Evidence struct {
	_ struct{} `type:"structure"`

	// A list of threat intelligence details related to the evidence.
	ThreatIntelligenceDetails []ThreatIntelligenceDetail `locationName:"threatIntelligenceDetails" type:"list"`
}

// String returns the string representation
func (s Evidence) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Evidence) MarshalFields(e protocol.FieldEncoder) error {
	if s.ThreatIntelligenceDetails != nil {
		v := s.ThreatIntelligenceDetails

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "threatIntelligenceDetails", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains information about the finding, which is generated when abnormal
// or suspicious activity is detected.
type Finding struct {
	_ struct{} `type:"structure"`

	// The ID of the account in which the finding was generated.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`

	// The ARN of the finding.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The confidence score for the finding.
	Confidence *float64 `locationName:"confidence" type:"double"`

	// The time and date when the finding was created.
	//
	// CreatedAt is a required field
	CreatedAt *string `locationName:"createdAt" type:"string" required:"true"`

	// The description of the finding.
	Description *string `locationName:"description" type:"string"`

	// The ID of the finding.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The partition associated with the finding.
	Partition *string `locationName:"partition" type:"string"`

	// The Region where the finding was generated.
	//
	// Region is a required field
	Region *string `locationName:"region" type:"string" required:"true"`

	// Contains information about the AWS resource associated with the activity
	// that prompted GuardDuty to generate a finding.
	//
	// Resource is a required field
	Resource *Resource `locationName:"resource" type:"structure" required:"true"`

	// The version of the schema used for the finding.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `locationName:"schemaVersion" type:"string" required:"true"`

	// Contains additional information about the generated finding.
	Service *Service `locationName:"service" type:"structure"`

	// The severity of the finding.
	//
	// Severity is a required field
	Severity *float64 `locationName:"severity" type:"double" required:"true"`

	// The title of the finding.
	Title *string `locationName:"title" type:"string"`

	// The type of finding.
	//
	// Type is a required field
	Type *string `locationName:"type" min:"1" type:"string" required:"true"`

	// The time and date when the finding was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `locationName:"updatedAt" type:"string" required:"true"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Finding) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Confidence != nil {
		v := *s.Confidence

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "confidence", protocol.Float64Value(v), metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Partition != nil {
		v := *s.Partition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Resource != nil {
		v := s.Resource

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resource", v, metadata)
	}
	if s.SchemaVersion != nil {
		v := *s.SchemaVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schemaVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Service != nil {
		v := s.Service

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "service", v, metadata)
	}
	if s.Severity != nil {
		v := *s.Severity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "severity", protocol.Float64Value(v), metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the criteria used for querying findings.
type FindingCriteria struct {
	_ struct{} `type:"structure"`

	// Represents a map of finding properties that match specified conditions and
	// values when querying findings.
	Criterion map[string]Condition `locationName:"criterion" type:"map"`
}

// String returns the string representation
func (s FindingCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.Criterion != nil {
		v := s.Criterion

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "criterion", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Contains information about finding statistics.
type FindingStatistics struct {
	_ struct{} `type:"structure"`

	// Represents a map of severity to count statistics for a set of findings.
	CountBySeverity map[string]int64 `locationName:"countBySeverity" type:"map"`
}

// String returns the string representation
func (s FindingStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.CountBySeverity != nil {
		v := s.CountBySeverity

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "countBySeverity", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Int64Value(v1))
		}
		ms0.End()

	}
	return nil
}

// Contains information about the location of the remote IP address.
type GeoLocation struct {
	_ struct{} `type:"structure"`

	// The latitude information of the remote IP address.
	Lat *float64 `locationName:"lat" type:"double"`

	// The longitude information of the remote IP address.
	Lon *float64 `locationName:"lon" type:"double"`
}

// String returns the string representation
func (s GeoLocation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GeoLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Lat != nil {
		v := *s.Lat

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lat", protocol.Float64Value(v), metadata)
	}
	if s.Lon != nil {
		v := *s.Lon

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lon", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Contains information about the EC2 instance profile.
type IamInstanceProfile struct {
	_ struct{} `type:"structure"`

	// The profile ARN of the EC2 instance.
	Arn *string `locationName:"arn" type:"string"`

	// The profile ID of the EC2 instance.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s IamInstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IamInstanceProfile) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the details of an instance.
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the EC2 instance.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The profile information of the EC2 instance.
	IamInstanceProfile *IamInstanceProfile `locationName:"iamInstanceProfile" type:"structure"`

	// The image description of the EC2 instance.
	ImageDescription *string `locationName:"imageDescription" type:"string"`

	// The image ID of the EC2 instance.
	ImageId *string `locationName:"imageId" type:"string"`

	// The ID of the EC2 instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The state of the EC2 instance.
	InstanceState *string `locationName:"instanceState" type:"string"`

	// The type of the EC2 instance.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The launch time of the EC2 instance.
	LaunchTime *string `locationName:"launchTime" type:"string"`

	// The elastic network interface information of the EC2 instance.
	NetworkInterfaces []NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// The Amazon Resource Name (ARN) of the AWS Outpost. Only applicable to AWS
	// Outposts instances.
	OutpostArn *string `locationName:"outpostArn" type:"string"`

	// The platform of the EC2 instance.
	Platform *string `locationName:"platform" type:"string"`

	// The product code of the EC2 instance.
	ProductCodes []ProductCode `locationName:"productCodes" type:"list"`

	// The tags of the EC2 instance.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InstanceDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZone != nil {
		v := *s.AvailabilityZone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "availabilityZone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IamInstanceProfile != nil {
		v := s.IamInstanceProfile

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "iamInstanceProfile", v, metadata)
	}
	if s.ImageDescription != nil {
		v := *s.ImageDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageId != nil {
		v := *s.ImageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceState != nil {
		v := *s.InstanceState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceState", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceType != nil {
		v := *s.InstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchTime != nil {
		v := *s.LaunchTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "launchTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NetworkInterfaces != nil {
		v := s.NetworkInterfaces

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "networkInterfaces", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.OutpostArn != nil {
		v := *s.OutpostArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "outpostArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductCodes != nil {
		v := s.ProductCodes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "productCodes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains information about the invitation to become a member account.
type Invitation struct {
	_ struct{} `type:"structure"`

	// The ID of the account that the invitation was sent from.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The ID of the invitation. This value is used to validate the inviter account
	// to the member account.
	InvitationId *string `locationName:"invitationId" type:"string"`

	// The timestamp when the invitation was sent.
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The status of the relationship between the inviter and invitee accounts.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Invitation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitationId != nil {
		v := *s.InvitationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RelationshipStatus != nil {
		v := *s.RelationshipStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "relationshipStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the local IP address of the connection.
type LocalIpDetails struct {
	_ struct{} `type:"structure"`

	// The IPv4 local address of the connection.
	IpAddressV4 *string `locationName:"ipAddressV4" type:"string"`
}

// String returns the string representation
func (s LocalIpDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LocalIpDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.IpAddressV4 != nil {
		v := *s.IpAddressV4

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ipAddressV4", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the port for the local connection.
type LocalPortDetails struct {
	_ struct{} `type:"structure"`

	// The port number of the local connection.
	Port *int64 `locationName:"port" type:"integer"`

	// The port name of the local connection.
	PortName *string `locationName:"portName" type:"string"`
}

// String returns the string representation
func (s LocalPortDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LocalPortDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	if s.PortName != nil {
		v := *s.PortName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the master account and invitation.
type Master struct {
	_ struct{} `type:"structure"`

	// The ID of the account used as the master account.
	AccountId *string `locationName:"accountId" min:"12" type:"string"`

	// The value used to validate the master account to the member account.
	InvitationId *string `locationName:"invitationId" type:"string"`

	// The timestamp when the invitation was sent.
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The status of the relationship between the master and member accounts.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string"`
}

// String returns the string representation
func (s Master) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Master) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitationId != nil {
		v := *s.InvitationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RelationshipStatus != nil {
		v := *s.RelationshipStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "relationshipStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the member account.
type Member struct {
	_ struct{} `type:"structure"`

	// The ID of the member account.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// The detector ID of the member account.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The email address of the member account.
	//
	// Email is a required field
	Email *string `locationName:"email" min:"1" type:"string" required:"true"`

	// The timestamp when the invitation was sent.
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The master account ID.
	//
	// MasterId is a required field
	MasterId *string `locationName:"masterId" type:"string" required:"true"`

	// The status of the relationship between the member and the master.
	//
	// RelationshipStatus is a required field
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string" required:"true"`

	// The last-updated timestamp of the member.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `locationName:"updatedAt" type:"string" required:"true"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Member) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MasterId != nil {
		v := *s.MasterId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "masterId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RelationshipStatus != nil {
		v := *s.RelationshipStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "relationshipStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the NETWORK_CONNECTION action described in the
// finding.
type NetworkConnectionAction struct {
	_ struct{} `type:"structure"`

	// Indicates whether EC2 blocked the network connection to your instance.
	Blocked *bool `locationName:"blocked" type:"boolean"`

	// The network connection direction.
	ConnectionDirection *string `locationName:"connectionDirection" type:"string"`

	// The local IP information of the connection.
	LocalIpDetails *LocalIpDetails `locationName:"localIpDetails" type:"structure"`

	// The local port information of the connection.
	LocalPortDetails *LocalPortDetails `locationName:"localPortDetails" type:"structure"`

	// The network connection protocol.
	Protocol *string `locationName:"protocol" type:"string"`

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`

	// The remote port information of the connection.
	RemotePortDetails *RemotePortDetails `locationName:"remotePortDetails" type:"structure"`
}

// String returns the string representation
func (s NetworkConnectionAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkConnectionAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Blocked != nil {
		v := *s.Blocked

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blocked", protocol.BoolValue(v), metadata)
	}
	if s.ConnectionDirection != nil {
		v := *s.ConnectionDirection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionDirection", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LocalIpDetails != nil {
		v := s.LocalIpDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "localIpDetails", v, metadata)
	}
	if s.LocalPortDetails != nil {
		v := s.LocalPortDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "localPortDetails", v, metadata)
	}
	if s.Protocol != nil {
		v := *s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocol", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RemoteIpDetails != nil {
		v := s.RemoteIpDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remoteIpDetails", v, metadata)
	}
	if s.RemotePortDetails != nil {
		v := s.RemotePortDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remotePortDetails", v, metadata)
	}
	return nil
}

// Contains information about the elastic network interface of the EC2 instance.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// A list of IPv6 addresses for the EC2 instance.
	Ipv6Addresses []string `locationName:"ipv6Addresses" type:"list"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The private DNS name of the EC2 instance.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IP address of the EC2 instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// Other private IP address information of the EC2 instance.
	PrivateIpAddresses []PrivateIpAddressDetails `locationName:"privateIpAddresses" type:"list"`

	// The public DNS name of the EC2 instance.
	PublicDnsName *string `locationName:"publicDnsName" type:"string"`

	// The public IP address of the EC2 instance.
	PublicIp *string `locationName:"publicIp" type:"string"`

	// The security groups associated with the EC2 instance.
	SecurityGroups []SecurityGroup `locationName:"securityGroups" type:"list"`

	// The subnet ID of the EC2 instance.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The VPC ID of the EC2 instance.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkInterface) MarshalFields(e protocol.FieldEncoder) error {
	if s.Ipv6Addresses != nil {
		v := s.Ipv6Addresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ipv6Addresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NetworkInterfaceId != nil {
		v := *s.NetworkInterfaceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "networkInterfaceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrivateDnsName != nil {
		v := *s.PrivateDnsName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privateDnsName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrivateIpAddress != nil {
		v := *s.PrivateIpAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privateIpAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrivateIpAddresses != nil {
		v := s.PrivateIpAddresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "privateIpAddresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.PublicDnsName != nil {
		v := *s.PublicDnsName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "publicDnsName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PublicIp != nil {
		v := *s.PublicIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "publicIp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroups != nil {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SubnetId != nil {
		v := *s.SubnetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "subnetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the ISP organization of the remote IP address.
type Organization struct {
	_ struct{} `type:"structure"`

	// The Autonomous System Number (ASN) of the internet provider of the remote
	// IP address.
	Asn *string `locationName:"asn" type:"string"`

	// The organization that registered this ASN.
	AsnOrg *string `locationName:"asnOrg" type:"string"`

	// The ISP information for the internet provider.
	Isp *string `locationName:"isp" type:"string"`

	// The name of the internet provider.
	Org *string `locationName:"org" type:"string"`
}

// String returns the string representation
func (s Organization) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Organization) MarshalFields(e protocol.FieldEncoder) error {
	if s.Asn != nil {
		v := *s.Asn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "asn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AsnOrg != nil {
		v := *s.AsnOrg

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "asnOrg", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Isp != nil {
		v := *s.Isp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Org != nil {
		v := *s.Org

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "org", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information on the owner of the bucket.
type Owner struct {
	_ struct{} `type:"structure"`

	// The canonical user ID of the bucket owner. For information about locating
	// your canonical user ID see Finding Your Account Canonical User ID. (https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId)
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s Owner) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Owner) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about how permissions are configured for the S3 bucket.
type PermissionConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains information about the account level permissions on the S3 bucket.
	AccountLevelPermissions *AccountLevelPermissions `locationName:"accountLevelPermissions" type:"structure"`

	// Contains information about the bucket level permissions for the S3 bucket.
	BucketLevelPermissions *BucketLevelPermissions `locationName:"bucketLevelPermissions" type:"structure"`
}

// String returns the string representation
func (s PermissionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PermissionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountLevelPermissions != nil {
		v := s.AccountLevelPermissions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accountLevelPermissions", v, metadata)
	}
	if s.BucketLevelPermissions != nil {
		v := s.BucketLevelPermissions

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "bucketLevelPermissions", v, metadata)
	}
	return nil
}

// Contains information about the PORT_PROBE action described in the finding.
type PortProbeAction struct {
	_ struct{} `type:"structure"`

	// Indicates whether EC2 blocked the port probe to the instance, such as with
	// an ACL.
	Blocked *bool `locationName:"blocked" type:"boolean"`

	// A list of objects related to port probe details.
	PortProbeDetails []PortProbeDetail `locationName:"portProbeDetails" type:"list"`
}

// String returns the string representation
func (s PortProbeAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortProbeAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Blocked != nil {
		v := *s.Blocked

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blocked", protocol.BoolValue(v), metadata)
	}
	if s.PortProbeDetails != nil {
		v := s.PortProbeDetails

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "portProbeDetails", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains information about the port probe details.
type PortProbeDetail struct {
	_ struct{} `type:"structure"`

	// The local IP information of the connection.
	LocalIpDetails *LocalIpDetails `locationName:"localIpDetails" type:"structure"`

	// The local port information of the connection.
	LocalPortDetails *LocalPortDetails `locationName:"localPortDetails" type:"structure"`

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`
}

// String returns the string representation
func (s PortProbeDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortProbeDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.LocalIpDetails != nil {
		v := s.LocalIpDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "localIpDetails", v, metadata)
	}
	if s.LocalPortDetails != nil {
		v := s.LocalPortDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "localPortDetails", v, metadata)
	}
	if s.RemoteIpDetails != nil {
		v := s.RemoteIpDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remoteIpDetails", v, metadata)
	}
	return nil
}

// Contains other private IP address information of the EC2 instance.
type PrivateIpAddressDetails struct {
	_ struct{} `type:"structure"`

	// The private DNS name of the EC2 instance.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// The private IP address of the EC2 instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`
}

// String returns the string representation
func (s PrivateIpAddressDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PrivateIpAddressDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.PrivateDnsName != nil {
		v := *s.PrivateDnsName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privateDnsName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrivateIpAddress != nil {
		v := *s.PrivateIpAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privateIpAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the product code for the EC2 instance.
type ProductCode struct {
	_ struct{} `type:"structure"`

	// The product code information.
	Code *string `locationName:"code" type:"string"`

	// The product code type.
	ProductType *string `locationName:"productType" type:"string"`
}

// String returns the string representation
func (s ProductCode) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProductCode) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := *s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductType != nil {
		v := *s.ProductType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "productType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the public access policies that apply to the S3 bucket.
type PublicAccess struct {
	_ struct{} `type:"structure"`

	// Describes the effective permission on this bucket after factoring all attached
	// policies.
	EffectivePermission *string `locationName:"effectivePermission" type:"string"`

	// Contains information about how permissions are configured for the S3 bucket.
	PermissionConfiguration *PermissionConfiguration `locationName:"permissionConfiguration" type:"structure"`
}

// String returns the string representation
func (s PublicAccess) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PublicAccess) MarshalFields(e protocol.FieldEncoder) error {
	if s.EffectivePermission != nil {
		v := *s.EffectivePermission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "effectivePermission", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PermissionConfiguration != nil {
		v := s.PermissionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "permissionConfiguration", v, metadata)
	}
	return nil
}

// Contains information about the remote IP address of the connection.
type RemoteIpDetails struct {
	_ struct{} `type:"structure"`

	// The city information of the remote IP address.
	City *City `locationName:"city" type:"structure"`

	// The country code of the remote IP address.
	Country *Country `locationName:"country" type:"structure"`

	// The location information of the remote IP address.
	GeoLocation *GeoLocation `locationName:"geoLocation" type:"structure"`

	// The IPv4 remote address of the connection.
	IpAddressV4 *string `locationName:"ipAddressV4" type:"string"`

	// The ISP organization information of the remote IP address.
	Organization *Organization `locationName:"organization" type:"structure"`
}

// String returns the string representation
func (s RemoteIpDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoteIpDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.City != nil {
		v := s.City

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "city", v, metadata)
	}
	if s.Country != nil {
		v := s.Country

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "country", v, metadata)
	}
	if s.GeoLocation != nil {
		v := s.GeoLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "geoLocation", v, metadata)
	}
	if s.IpAddressV4 != nil {
		v := *s.IpAddressV4

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ipAddressV4", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Organization != nil {
		v := s.Organization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "organization", v, metadata)
	}
	return nil
}

// Contains information about the remote port.
type RemotePortDetails struct {
	_ struct{} `type:"structure"`

	// The port number of the remote connection.
	Port *int64 `locationName:"port" type:"integer"`

	// The port name of the remote connection.
	PortName *string `locationName:"portName" type:"string"`
}

// String returns the string representation
func (s RemotePortDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemotePortDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	if s.PortName != nil {
		v := *s.PortName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the AWS resource associated with the activity
// that prompted GuardDuty to generate a finding.
type Resource struct {
	_ struct{} `type:"structure"`

	// The IAM access key details (IAM user information) of a user that engaged
	// in the activity that prompted GuardDuty to generate a finding.
	AccessKeyDetails *AccessKeyDetails `locationName:"accessKeyDetails" type:"structure"`

	// The information about the EC2 instance associated with the activity that
	// prompted GuardDuty to generate a finding.
	InstanceDetails *InstanceDetails `locationName:"instanceDetails" type:"structure"`

	// The type of AWS resource.
	ResourceType *string `locationName:"resourceType" type:"string"`

	// Contains information on the S3 bucket.
	S3BucketDetails []S3BucketDetail `locationName:"s3BucketDetails" type:"list"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Resource) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessKeyDetails != nil {
		v := s.AccessKeyDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessKeyDetails", v, metadata)
	}
	if s.InstanceDetails != nil {
		v := s.InstanceDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "instanceDetails", v, metadata)
	}
	if s.ResourceType != nil {
		v := *s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3BucketDetails != nil {
		v := s.S3BucketDetails

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "s3BucketDetails", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

type S3BucketDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 bucket.
	Arn *string `locationName:"arn" type:"string"`

	// The date and time the bucket was created at.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Describes the server side encryption method used in the S3 bucket.
	DefaultServerSideEncryption *DefaultServerSideEncryption `locationName:"defaultServerSideEncryption" type:"structure"`

	// The name of the S3 bucket.
	Name *string `locationName:"name" type:"string"`

	// The owner of the S3 bucket.
	Owner *Owner `locationName:"owner" type:"structure"`

	// Describes the public access policies that apply to the S3 bucket.
	PublicAccess *PublicAccess `locationName:"publicAccess" type:"structure"`

	// All tags attached to the S3 bucket
	Tags []Tag `locationName:"tags" type:"list"`

	// Describes whether the bucket is a source or destination bucket.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s S3BucketDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3BucketDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DefaultServerSideEncryption != nil {
		v := s.DefaultServerSideEncryption

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "defaultServerSideEncryption", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owner != nil {
		v := s.Owner

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "owner", v, metadata)
	}
	if s.PublicAccess != nil {
		v := s.PublicAccess

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "publicAccess", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the security groups associated with the EC2 instance.
type SecurityGroup struct {
	_ struct{} `type:"structure"`

	// The security group ID of the EC2 instance.
	GroupId *string `locationName:"groupId" type:"string"`

	// The security group name of the EC2 instance.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation
func (s SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SecurityGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupId != nil {
		v := *s.GroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains additional information about the generated finding.
type Service struct {
	_ struct{} `type:"structure"`

	// Information about the activity that is described in a finding.
	Action *Action `locationName:"action" type:"structure"`

	// Indicates whether this finding is archived.
	Archived *bool `locationName:"archived" type:"boolean"`

	// The total count of the occurrences of this finding type.
	Count *int64 `locationName:"count" type:"integer"`

	// The detector ID for the GuardDuty service.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The first-seen timestamp of the activity that prompted GuardDuty to generate
	// this finding.
	EventFirstSeen *string `locationName:"eventFirstSeen" type:"string"`

	// The last-seen timestamp of the activity that prompted GuardDuty to generate
	// this finding.
	EventLastSeen *string `locationName:"eventLastSeen" type:"string"`

	// An evidence object associated with the service.
	Evidence *Evidence `locationName:"evidence" type:"structure"`

	// The resource role information for this finding.
	ResourceRole *string `locationName:"resourceRole" type:"string"`

	// The name of the AWS service (GuardDuty) that generated a finding.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// Feedback that was submitted about the finding.
	UserFeedback *string `locationName:"userFeedback" type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Service) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "action", v, metadata)
	}
	if s.Archived != nil {
		v := *s.Archived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "archived", protocol.BoolValue(v), metadata)
	}
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventFirstSeen != nil {
		v := *s.EventFirstSeen

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "eventFirstSeen", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventLastSeen != nil {
		v := *s.EventLastSeen

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "eventLastSeen", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Evidence != nil {
		v := s.Evidence

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "evidence", v, metadata)
	}
	if s.ResourceRole != nil {
		v := *s.ResourceRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceName != nil {
		v := *s.ServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserFeedback != nil {
		v := *s.UserFeedback

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userFeedback", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about the criteria used for sorting findings.
type SortCriteria struct {
	_ struct{} `type:"structure"`

	// Represents the finding attribute (for example, accountId) to sort findings
	// by.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// The order by which the sorted findings are to be displayed.
	OrderBy OrderBy `locationName:"orderBy" type:"string" enum:"true"`
}

// String returns the string representation
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SortCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributeName != nil {
		v := *s.AttributeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attributeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OrderBy) > 0 {
		v := s.OrderBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "orderBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Contains information about a tag associated with the EC2 instance.
type Tag struct {
	_ struct{} `type:"structure"`

	// The EC2 instance tag key.
	Key *string `locationName:"key" type:"string"`

	// The EC2 instance tag value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An instance of a threat intelligence detail that constitutes evidence for
// the finding.
type ThreatIntelligenceDetail struct {
	_ struct{} `type:"structure"`

	// The name of the threat intelligence list that triggered the finding.
	ThreatListName *string `locationName:"threatListName" type:"string"`

	// A list of names of the threats in the threat intelligence list that triggered
	// the finding.
	ThreatNames []string `locationName:"threatNames" type:"list"`
}

// String returns the string representation
func (s ThreatIntelligenceDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThreatIntelligenceDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.ThreatListName != nil {
		v := *s.ThreatListName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "threatListName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThreatNames != nil {
		v := s.ThreatNames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "threatNames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Contains information about the accounts that weren't processed.
type UnprocessedAccount struct {
	_ struct{} `type:"structure"`

	// The AWS account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" min:"12" type:"string" required:"true"`

	// A reason why the account hasn't been processed.
	//
	// Result is a required field
	Result *string `locationName:"result" type:"string" required:"true"`
}

// String returns the string representation
func (s UnprocessedAccount) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnprocessedAccount) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Result != nil {
		v := *s.Result

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "result", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
