// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetAssociatedRoleInput struct {
	_ struct{} `type:"structure"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAssociatedRoleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssociatedRoleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAssociatedRoleInput"}

	if s.GroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAssociatedRoleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.GroupId != nil {
		v := *s.GroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "GroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetAssociatedRoleOutput struct {
	_ struct{} `type:"structure"`

	// The time when the role was associated with the group.
	AssociatedAt *string `type:"string"`

	// The ARN of the role that is associated with the group.
	RoleArn *string `type:"string"`
}

// String returns the string representation
func (s GetAssociatedRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAssociatedRoleOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssociatedAt != nil {
		v := *s.AssociatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssociatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetAssociatedRole = "GetAssociatedRole"

// GetAssociatedRoleRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Retrieves the role associated with a particular group.
//
//    // Example sending a request using GetAssociatedRoleRequest.
//    req := client.GetAssociatedRoleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole
func (c *Client) GetAssociatedRoleRequest(input *GetAssociatedRoleInput) GetAssociatedRoleRequest {
	op := &aws.Operation{
		Name:       opGetAssociatedRole,
		HTTPMethod: "GET",
		HTTPPath:   "/greengrass/groups/{GroupId}/role",
	}

	if input == nil {
		input = &GetAssociatedRoleInput{}
	}

	req := c.newRequest(op, input, &GetAssociatedRoleOutput{})

	return GetAssociatedRoleRequest{Request: req, Input: input, Copy: c.GetAssociatedRoleRequest}
}

// GetAssociatedRoleRequest is the request type for the
// GetAssociatedRole API operation.
type GetAssociatedRoleRequest struct {
	*aws.Request
	Input *GetAssociatedRoleInput
	Copy  func(*GetAssociatedRoleInput) GetAssociatedRoleRequest
}

// Send marshals and sends the GetAssociatedRole API request.
func (r GetAssociatedRoleRequest) Send(ctx context.Context) (*GetAssociatedRoleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAssociatedRoleResponse{
		GetAssociatedRoleOutput: r.Request.Data.(*GetAssociatedRoleOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAssociatedRoleResponse is the response type for the
// GetAssociatedRole API operation.
type GetAssociatedRoleResponse struct {
	*GetAssociatedRoleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAssociatedRole request.
func (r *GetAssociatedRoleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
