// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateWorkflowInput struct {
	_ struct{} `type:"structure"`

	// A collection of properties to be used as part of each execution of the workflow.
	DefaultRunProperties map[string]string `type:"map"`

	// The description of the workflow.
	Description *string `type:"string"`

	// Name of the workflow to be updated.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateWorkflowInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkflowInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateWorkflowInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateWorkflowOutput struct {
	_ struct{} `type:"structure"`

	// The name of the workflow which was specified in input.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateWorkflowOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateWorkflow = "UpdateWorkflow"

// UpdateWorkflowRequest returns a request value for making API operation for
// AWS Glue.
//
// Updates an existing workflow.
//
//    // Example sending a request using UpdateWorkflowRequest.
//    req := client.UpdateWorkflowRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateWorkflow
func (c *Client) UpdateWorkflowRequest(input *UpdateWorkflowInput) UpdateWorkflowRequest {
	op := &aws.Operation{
		Name:       opUpdateWorkflow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkflowInput{}
	}

	req := c.newRequest(op, input, &UpdateWorkflowOutput{})

	return UpdateWorkflowRequest{Request: req, Input: input, Copy: c.UpdateWorkflowRequest}
}

// UpdateWorkflowRequest is the request type for the
// UpdateWorkflow API operation.
type UpdateWorkflowRequest struct {
	*aws.Request
	Input *UpdateWorkflowInput
	Copy  func(*UpdateWorkflowInput) UpdateWorkflowRequest
}

// Send marshals and sends the UpdateWorkflow API request.
func (r UpdateWorkflowRequest) Send(ctx context.Context) (*UpdateWorkflowResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateWorkflowResponse{
		UpdateWorkflowOutput: r.Request.Data.(*UpdateWorkflowOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateWorkflowResponse is the response type for the
// UpdateWorkflow API operation.
type UpdateWorkflowResponse struct {
	*UpdateWorkflowOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateWorkflow request.
func (r *UpdateWorkflowResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
