// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateCrawlerScheduleInput struct {
	_ struct{} `type:"structure"`

	// The name of the crawler whose schedule to update.
	//
	// CrawlerName is a required field
	CrawlerName *string `min:"1" type:"string" required:"true"`

	// The updated cron expression used to specify the schedule (see Time-Based
	// Schedules for Jobs and Crawlers (https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`
}

// String returns the string representation
func (s UpdateCrawlerScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCrawlerScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateCrawlerScheduleInput"}

	if s.CrawlerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CrawlerName"))
	}
	if s.CrawlerName != nil && len(*s.CrawlerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CrawlerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateCrawlerScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCrawlerScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateCrawlerSchedule = "UpdateCrawlerSchedule"

// UpdateCrawlerScheduleRequest returns a request value for making API operation for
// AWS Glue.
//
// Updates the schedule of a crawler using a cron expression.
//
//    // Example sending a request using UpdateCrawlerScheduleRequest.
//    req := client.UpdateCrawlerScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawlerSchedule
func (c *Client) UpdateCrawlerScheduleRequest(input *UpdateCrawlerScheduleInput) UpdateCrawlerScheduleRequest {
	op := &aws.Operation{
		Name:       opUpdateCrawlerSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCrawlerScheduleInput{}
	}

	req := c.newRequest(op, input, &UpdateCrawlerScheduleOutput{})

	return UpdateCrawlerScheduleRequest{Request: req, Input: input, Copy: c.UpdateCrawlerScheduleRequest}
}

// UpdateCrawlerScheduleRequest is the request type for the
// UpdateCrawlerSchedule API operation.
type UpdateCrawlerScheduleRequest struct {
	*aws.Request
	Input *UpdateCrawlerScheduleInput
	Copy  func(*UpdateCrawlerScheduleInput) UpdateCrawlerScheduleRequest
}

// Send marshals and sends the UpdateCrawlerSchedule API request.
func (r UpdateCrawlerScheduleRequest) Send(ctx context.Context) (*UpdateCrawlerScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateCrawlerScheduleResponse{
		UpdateCrawlerScheduleOutput: r.Request.Data.(*UpdateCrawlerScheduleOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateCrawlerScheduleResponse is the response type for the
// UpdateCrawlerSchedule API operation.
type UpdateCrawlerScheduleResponse struct {
	*UpdateCrawlerScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateCrawlerSchedule request.
func (r *UpdateCrawlerScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
