// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetColumnStatisticsForTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partitions in question reside. If none
	// is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A list of the column names.
	//
	// ColumnNames is a required field
	ColumnNames []string `type:"list" required:"true"`

	// The name of the catalog database where the partitions reside.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the partitions' table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetColumnStatisticsForTableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetColumnStatisticsForTableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetColumnStatisticsForTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.ColumnNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnNames"))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetColumnStatisticsForTableOutput struct {
	_ struct{} `type:"structure"`

	// List of ColumnStatistics that failed to be retrieved.
	ColumnStatisticsList []ColumnStatistics `type:"list"`

	// List of ColumnStatistics that failed to be retrieved.
	Errors []ColumnError `type:"list"`
}

// String returns the string representation
func (s GetColumnStatisticsForTableOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetColumnStatisticsForTable = "GetColumnStatisticsForTable"

// GetColumnStatisticsForTableRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves table statistics of columns.
//
//    // Example sending a request using GetColumnStatisticsForTableRequest.
//    req := client.GetColumnStatisticsForTableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetColumnStatisticsForTable
func (c *Client) GetColumnStatisticsForTableRequest(input *GetColumnStatisticsForTableInput) GetColumnStatisticsForTableRequest {
	op := &aws.Operation{
		Name:       opGetColumnStatisticsForTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetColumnStatisticsForTableInput{}
	}

	req := c.newRequest(op, input, &GetColumnStatisticsForTableOutput{})

	return GetColumnStatisticsForTableRequest{Request: req, Input: input, Copy: c.GetColumnStatisticsForTableRequest}
}

// GetColumnStatisticsForTableRequest is the request type for the
// GetColumnStatisticsForTable API operation.
type GetColumnStatisticsForTableRequest struct {
	*aws.Request
	Input *GetColumnStatisticsForTableInput
	Copy  func(*GetColumnStatisticsForTableInput) GetColumnStatisticsForTableRequest
}

// Send marshals and sends the GetColumnStatisticsForTable API request.
func (r GetColumnStatisticsForTableRequest) Send(ctx context.Context) (*GetColumnStatisticsForTableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetColumnStatisticsForTableResponse{
		GetColumnStatisticsForTableOutput: r.Request.Data.(*GetColumnStatisticsForTableOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetColumnStatisticsForTableResponse is the response type for the
// GetColumnStatisticsForTable API operation.
type GetColumnStatisticsForTableResponse struct {
	*GetColumnStatisticsForTableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetColumnStatisticsForTable request.
func (r *GetColumnStatisticsForTableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
