// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteColumnStatisticsForTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partitions in question reside. If none
	// is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the column.
	//
	// ColumnName is a required field
	ColumnName *string `min:"1" type:"string" required:"true"`

	// The name of the catalog database where the partitions reside.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the partitions' table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteColumnStatisticsForTableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteColumnStatisticsForTableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteColumnStatisticsForTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.ColumnName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ColumnName", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteColumnStatisticsForTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteColumnStatisticsForTableOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteColumnStatisticsForTable = "DeleteColumnStatisticsForTable"

// DeleteColumnStatisticsForTableRequest returns a request value for making API operation for
// AWS Glue.
//
// Retrieves table statistics of columns.
//
//    // Example sending a request using DeleteColumnStatisticsForTableRequest.
//    req := client.DeleteColumnStatisticsForTableRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteColumnStatisticsForTable
func (c *Client) DeleteColumnStatisticsForTableRequest(input *DeleteColumnStatisticsForTableInput) DeleteColumnStatisticsForTableRequest {
	op := &aws.Operation{
		Name:       opDeleteColumnStatisticsForTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteColumnStatisticsForTableInput{}
	}

	req := c.newRequest(op, input, &DeleteColumnStatisticsForTableOutput{})

	return DeleteColumnStatisticsForTableRequest{Request: req, Input: input, Copy: c.DeleteColumnStatisticsForTableRequest}
}

// DeleteColumnStatisticsForTableRequest is the request type for the
// DeleteColumnStatisticsForTable API operation.
type DeleteColumnStatisticsForTableRequest struct {
	*aws.Request
	Input *DeleteColumnStatisticsForTableInput
	Copy  func(*DeleteColumnStatisticsForTableInput) DeleteColumnStatisticsForTableRequest
}

// Send marshals and sends the DeleteColumnStatisticsForTable API request.
func (r DeleteColumnStatisticsForTableRequest) Send(ctx context.Context) (*DeleteColumnStatisticsForTableResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteColumnStatisticsForTableResponse{
		DeleteColumnStatisticsForTableOutput: r.Request.Data.(*DeleteColumnStatisticsForTableOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteColumnStatisticsForTableResponse is the response type for the
// DeleteColumnStatisticsForTable API operation.
type DeleteColumnStatisticsForTableResponse struct {
	*DeleteColumnStatisticsForTableOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteColumnStatisticsForTable request.
func (r *DeleteColumnStatisticsForTableResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
