// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type BatchGetJobsInput struct {
	_ struct{} `type:"structure"`

	// A list of job names, which might be the names returned from the ListJobs
	// operation.
	//
	// JobNames is a required field
	JobNames []string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "BatchGetJobsInput"}

	if s.JobNames == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type BatchGetJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job definitions.
	Jobs []Job `type:"list"`

	// A list of names of jobs not found.
	JobsNotFound []string `type:"list"`
}

// String returns the string representation
func (s BatchGetJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opBatchGetJobs = "BatchGetJobs"

// BatchGetJobsRequest returns a request value for making API operation for
// AWS Glue.
//
// Returns a list of resource metadata for a given list of job names. After
// calling the ListJobs operation, you can call this operation to access the
// data to which you have been granted permissions. This operation supports
// all IAM permissions, including permission conditions that uses tags.
//
//    // Example sending a request using BatchGetJobsRequest.
//    req := client.BatchGetJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetJobs
func (c *Client) BatchGetJobsRequest(input *BatchGetJobsInput) BatchGetJobsRequest {
	op := &aws.Operation{
		Name:       opBatchGetJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetJobsInput{}
	}

	req := c.newRequest(op, input, &BatchGetJobsOutput{})

	return BatchGetJobsRequest{Request: req, Input: input, Copy: c.BatchGetJobsRequest}
}

// BatchGetJobsRequest is the request type for the
// BatchGetJobs API operation.
type BatchGetJobsRequest struct {
	*aws.Request
	Input *BatchGetJobsInput
	Copy  func(*BatchGetJobsInput) BatchGetJobsRequest
}

// Send marshals and sends the BatchGetJobs API request.
func (r BatchGetJobsRequest) Send(ctx context.Context) (*BatchGetJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &BatchGetJobsResponse{
		BatchGetJobsOutput: r.Request.Data.(*BatchGetJobsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// BatchGetJobsResponse is the response type for the
// BatchGetJobs API operation.
type BatchGetJobsResponse struct {
	*BatchGetJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// BatchGetJobs request.
func (r *BatchGetJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
