// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package globalaccelerator

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListByoipCidrsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListByoipCidrsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListByoipCidrsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListByoipCidrsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListByoipCidrsOutput struct {
	_ struct{} `type:"structure"`

	// Information about your address ranges.
	ByoipCidrs []ByoipCidr `type:"list"`

	// The token for the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListByoipCidrsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListByoipCidrs = "ListByoipCidrs"

// ListByoipCidrsRequest returns a request value for making API operation for
// AWS Global Accelerator.
//
// Lists the IP address ranges that were specified in calls to ProvisionByoipCidr
// (https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html),
// including the current state and a history of state changes.
//
// To see an AWS CLI example of listing BYOIP CIDR addresses, scroll down to
// Example.
//
//    // Example sending a request using ListByoipCidrsRequest.
//    req := client.ListByoipCidrsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/globalaccelerator-2018-08-08/ListByoipCidrs
func (c *Client) ListByoipCidrsRequest(input *ListByoipCidrsInput) ListByoipCidrsRequest {
	op := &aws.Operation{
		Name:       opListByoipCidrs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListByoipCidrsInput{}
	}

	req := c.newRequest(op, input, &ListByoipCidrsOutput{})

	return ListByoipCidrsRequest{Request: req, Input: input, Copy: c.ListByoipCidrsRequest}
}

// ListByoipCidrsRequest is the request type for the
// ListByoipCidrs API operation.
type ListByoipCidrsRequest struct {
	*aws.Request
	Input *ListByoipCidrsInput
	Copy  func(*ListByoipCidrsInput) ListByoipCidrsRequest
}

// Send marshals and sends the ListByoipCidrs API request.
func (r ListByoipCidrsRequest) Send(ctx context.Context) (*ListByoipCidrsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListByoipCidrsResponse{
		ListByoipCidrsOutput: r.Request.Data.(*ListByoipCidrsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListByoipCidrsResponse is the response type for the
// ListByoipCidrs API operation.
type ListByoipCidrsResponse struct {
	*ListByoipCidrsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListByoipCidrs request.
func (r *ListByoipCidrsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
