// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Provides options to complete a multipart upload operation. This informs Amazon
// Glacier that all the archive parts have been uploaded and Amazon S3 Glacier
// (Glacier) can now assemble the archive from the uploaded parts. After assembling
// and saving the archive to the vault, Glacier returns the URI path of the
// newly created archive resource.
type CompleteMultipartUploadInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The total size, in bytes, of the entire archive. This value should be the
	// sum of all the sizes of the individual parts that you uploaded.
	ArchiveSize *string `location:"header" locationName:"x-amz-archive-size" type:"string"`

	// The SHA256 tree hash of the entire archive. It is the tree hash of SHA256
	// tree hash of the individual parts. If the value you specify in the request
	// does not match the SHA256 tree hash of the final assembled archive as computed
	// by Amazon S3 Glacier (Glacier), Glacier returns an error and the request
	// fails.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// The upload ID of the multipart upload.
	//
	// UploadId is a required field
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteMultipartUploadInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CompleteMultipartUploadInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.UploadId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UploadId"))
	}

	if s.VaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompleteMultipartUploadInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ArchiveSize != nil {
		v := *s.ArchiveSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-archive-size", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Checksum != nil {
		v := *s.Checksum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-sha256-tree-hash", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UploadId != nil {
		v := *s.UploadId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "uploadId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the Amazon S3 Glacier response to your request.
//
// For information about the underlying REST API, see Upload Archive (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html).
// For conceptual information, see Working with Archives in Amazon S3 Glacier
// (https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html).
type CompleteMultipartUploadOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the archive. This value is also included as part of the location.
	ArchiveId *string `location:"header" locationName:"x-amz-archive-id" type:"string"`

	// The checksum of the archive computed by Amazon S3 Glacier.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// The relative URI path of the newly added archive resource.
	Location *string `location:"header" locationName:"Location" type:"string"`
}

// String returns the string representation
func (s CompleteMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CompleteMultipartUploadOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArchiveId != nil {
		v := *s.ArchiveId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-archive-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Checksum != nil {
		v := *s.Checksum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-sha256-tree-hash", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCompleteMultipartUpload = "CompleteMultipartUpload"

// CompleteMultipartUploadRequest returns a request value for making API operation for
// Amazon Glacier.
//
// You call this operation to inform Amazon S3 Glacier (Glacier) that all the
// archive parts have been uploaded and that Glacier can now assemble the archive
// from the uploaded parts. After assembling and saving the archive to the vault,
// Glacier returns the URI path of the newly created archive resource. Using
// the URI path, you can then access the archive. After you upload an archive,
// you should save the archive ID returned to retrieve the archive at a later
// point. You can also get the vault inventory to obtain a list of archive IDs
// in a vault. For more information, see InitiateJob.
//
// In the request, you must include the computed SHA256 tree hash of the entire
// archive you have uploaded. For information about computing a SHA256 tree
// hash, see Computing Checksums (https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html).
// On the server side, Glacier also constructs the SHA256 tree hash of the assembled
// archive. If the values match, Glacier saves the archive to the vault; otherwise,
// it returns an error, and the operation fails. The ListParts operation returns
// a list of parts uploaded for a specific multipart upload. It includes checksum
// information for each uploaded part that can be used to debug a bad checksum
// issue.
//
// Additionally, Glacier also checks for any missing content ranges when assembling
// the archive, if missing content ranges are found, Glacier returns an error
// and the operation fails.
//
// Complete Multipart Upload is an idempotent operation. After your first successful
// complete multipart upload, if you call the operation again within a short
// period, the operation will succeed and return the same archive ID. This is
// useful in the event you experience a network issue that causes an aborted
// connection or receive a 500 server error, in which case you can repeat your
// Complete Multipart Upload request and get the same archive ID without creating
// duplicate archives. Note, however, that after the multipart upload completes,
// you cannot call the List Parts operation and the multipart upload will not
// appear in List Multipart Uploads response, even if idempotent complete is
// possible.
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Uploading Large Archives
// in Parts (Multipart Upload) (https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
// and Complete Multipart Upload (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-complete-upload.html)
// in the Amazon Glacier Developer Guide.
//
//    // Example sending a request using CompleteMultipartUploadRequest.
//    req := client.CompleteMultipartUploadRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CompleteMultipartUploadRequest(input *CompleteMultipartUploadInput) CompleteMultipartUploadRequest {
	op := &aws.Operation{
		Name:       opCompleteMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
	}

	if input == nil {
		input = &CompleteMultipartUploadInput{}
	}

	req := c.newRequest(op, input, &CompleteMultipartUploadOutput{})

	return CompleteMultipartUploadRequest{Request: req, Input: input, Copy: c.CompleteMultipartUploadRequest}
}

// CompleteMultipartUploadRequest is the request type for the
// CompleteMultipartUpload API operation.
type CompleteMultipartUploadRequest struct {
	*aws.Request
	Input *CompleteMultipartUploadInput
	Copy  func(*CompleteMultipartUploadInput) CompleteMultipartUploadRequest
}

// Send marshals and sends the CompleteMultipartUpload API request.
func (r CompleteMultipartUploadRequest) Send(ctx context.Context) (*CompleteMultipartUploadResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CompleteMultipartUploadResponse{
		CompleteMultipartUploadOutput: r.Request.Data.(*CompleteMultipartUploadOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CompleteMultipartUploadResponse is the response type for the
// CompleteMultipartUpload API operation.
type CompleteMultipartUploadResponse struct {
	*CompleteMultipartUploadOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CompleteMultipartUpload request.
func (r *CompleteMultipartUploadResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
