// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListGameServerGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// A token that indicates the start of the next sequential page of results.
	// Use the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGameServerGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGameServerGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListGameServerGroupsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListGameServerGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A collection of game server group objects that match the request.
	GameServerGroups []GameServerGroup `type:"list"`

	// A token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGameServerGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListGameServerGroups = "ListGameServerGroups"

// ListGameServerGroupsRequest returns a request value for making API operation for
// Amazon GameLift.
//
// This action is part of Amazon GameLift FleetIQ with game server groups, which
// is in preview release and is subject to change.
//
// Retrieves information on all game servers groups that exist in the current
// AWS account for the selected region. Use the pagination parameters to retrieve
// results in a set of sequential pages.
//
// Learn more
//
// GameLift FleetIQ Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gsg-intro.html)
//
// Related operations
//
//    * CreateGameServerGroup
//
//    * ListGameServerGroups
//
//    * DescribeGameServerGroup
//
//    * UpdateGameServerGroup
//
//    * DeleteGameServerGroup
//
//    * ResumeGameServerGroup
//
//    * SuspendGameServerGroup
//
//    // Example sending a request using ListGameServerGroupsRequest.
//    req := client.ListGameServerGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups
func (c *Client) ListGameServerGroupsRequest(input *ListGameServerGroupsInput) ListGameServerGroupsRequest {
	op := &aws.Operation{
		Name:       opListGameServerGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListGameServerGroupsInput{}
	}

	req := c.newRequest(op, input, &ListGameServerGroupsOutput{})

	return ListGameServerGroupsRequest{Request: req, Input: input, Copy: c.ListGameServerGroupsRequest}
}

// ListGameServerGroupsRequest is the request type for the
// ListGameServerGroups API operation.
type ListGameServerGroupsRequest struct {
	*aws.Request
	Input *ListGameServerGroupsInput
	Copy  func(*ListGameServerGroupsInput) ListGameServerGroupsRequest
}

// Send marshals and sends the ListGameServerGroups API request.
func (r ListGameServerGroupsRequest) Send(ctx context.Context) (*ListGameServerGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListGameServerGroupsResponse{
		ListGameServerGroupsOutput: r.Request.Data.(*ListGameServerGroupsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListGameServerGroupsResponse is the response type for the
// ListGameServerGroups API operation.
type ListGameServerGroupsResponse struct {
	*ListGameServerGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListGameServerGroups request.
func (r *ListGameServerGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
