// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type DescribeEC2InstanceLimitsInput struct {
	_ struct{} `type:"structure"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions. Leave
	// this parameter blank to retrieve limits for all types.
	EC2InstanceType EC2InstanceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeEC2InstanceLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// Represents the returned data in response to a request action.
type DescribeEC2InstanceLimitsOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of instances for the specified instance type.
	EC2InstanceLimits []EC2InstanceLimit `type:"list"`
}

// String returns the string representation
func (s DescribeEC2InstanceLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEC2InstanceLimits = "DescribeEC2InstanceLimits"

// DescribeEC2InstanceLimitsRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves the following information for the specified EC2 instance type:
//
//    * Maximum number of instances allowed per AWS account (service limit).
//
//    * Current usage for the AWS account.
//
// To learn more about the capabilities of each instance type, see Amazon EC2
// Instance Types (http://aws.amazon.com/ec2/instance-types/). Note that the
// instance types offered may vary depending on the region.
//
// Learn more
//
// Setting up GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html)
//
// Related operations
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * DescribeFleetAttributes
//
//    * UpdateFleetAttributes
//
//    * StartFleetActions or StopFleetActions
//
//    // Example sending a request using DescribeEC2InstanceLimitsRequest.
//    req := client.DescribeEC2InstanceLimitsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits
func (c *Client) DescribeEC2InstanceLimitsRequest(input *DescribeEC2InstanceLimitsInput) DescribeEC2InstanceLimitsRequest {
	op := &aws.Operation{
		Name:       opDescribeEC2InstanceLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEC2InstanceLimitsInput{}
	}

	req := c.newRequest(op, input, &DescribeEC2InstanceLimitsOutput{})

	return DescribeEC2InstanceLimitsRequest{Request: req, Input: input, Copy: c.DescribeEC2InstanceLimitsRequest}
}

// DescribeEC2InstanceLimitsRequest is the request type for the
// DescribeEC2InstanceLimits API operation.
type DescribeEC2InstanceLimitsRequest struct {
	*aws.Request
	Input *DescribeEC2InstanceLimitsInput
	Copy  func(*DescribeEC2InstanceLimitsInput) DescribeEC2InstanceLimitsRequest
}

// Send marshals and sends the DescribeEC2InstanceLimits API request.
func (r DescribeEC2InstanceLimitsRequest) Send(ctx context.Context) (*DescribeEC2InstanceLimitsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEC2InstanceLimitsResponse{
		DescribeEC2InstanceLimitsOutput: r.Request.Data.(*DescribeEC2InstanceLimitsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeEC2InstanceLimitsResponse is the response type for the
// DescribeEC2InstanceLimits API operation.
type DescribeEC2InstanceLimitsResponse struct {
	*DescribeEC2InstanceLimitsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEC2InstanceLimits request.
func (r *DescribeEC2InstanceLimitsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
