// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type DescribeBuildInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a build to retrieve properties for. You can use either
	// the build ID or ARN value.
	//
	// BuildId is a required field
	BuildId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeBuildInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBuildInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeBuildInput"}

	if s.BuildId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BuildId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
type DescribeBuildOutput struct {
	_ struct{} `type:"structure"`

	// Set of properties describing the requested build.
	Build *Build `type:"structure"`
}

// String returns the string representation
func (s DescribeBuildOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeBuild = "DescribeBuild"

// DescribeBuildRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves properties for a custom game build. To request a build resource,
// specify a build ID. If successful, an object containing the build properties
// is returned.
//
// Learn more
//
//  Upload a Custom Server Build (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html)
//
// Related operations
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
//
//    // Example sending a request using DescribeBuildRequest.
//    req := client.DescribeBuildRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild
func (c *Client) DescribeBuildRequest(input *DescribeBuildInput) DescribeBuildRequest {
	op := &aws.Operation{
		Name:       opDescribeBuild,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBuildInput{}
	}

	req := c.newRequest(op, input, &DescribeBuildOutput{})

	return DescribeBuildRequest{Request: req, Input: input, Copy: c.DescribeBuildRequest}
}

// DescribeBuildRequest is the request type for the
// DescribeBuild API operation.
type DescribeBuildRequest struct {
	*aws.Request
	Input *DescribeBuildInput
	Copy  func(*DescribeBuildInput) DescribeBuildRequest
}

// Send marshals and sends the DescribeBuild API request.
func (r DescribeBuildRequest) Send(ctx context.Context) (*DescribeBuildResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeBuildResponse{
		DescribeBuildOutput: r.Request.Data.(*DescribeBuildOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeBuildResponse is the response type for the
// DescribeBuild API operation.
type DescribeBuildResponse struct {
	*DescribeBuildOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeBuild request.
func (r *DescribeBuildResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
