// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// The Microsoft AD attributes of the Amazon FSx for Windows File Server file
// system.
type ActiveDirectoryBackupAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS Managed Microsoft Active Directory instance to which the
	// file system is joined.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The fully qualified domain name of the self-managed AD directory.
	DomainName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ActiveDirectoryBackupAttributes) String() string {
	return awsutil.Prettify(s)
}

// Describes a specific Amazon FSx Administrative Action for the current Windows
// file system.
type AdministrativeAction struct {
	_ struct{} `type:"structure"`

	// Describes the type of administrative action, as follows:
	//
	//    * FILE_SYSTEM_UPDATE - A file system update administrative action initiated
	//    by the user from the Amazon FSx console, API (UpdateFileSystem), or CLI
	//    (update-file-system). A
	//
	//    * STORAGE_OPTIMIZATION - Once the FILE_SYSTEM_UPDATE task to increase
	//    a file system's storage capacity completes successfully, a STORAGE_OPTIMIZATION
	//    task starts. Storage optimization is the process of migrating the file
	//    system data to the new, larger disks. You can track the storage migration
	//    progress using the ProgressPercent property. When STORAGE_OPTIMIZATION
	//    completes successfully, the parent FILE_SYSTEM_UPDATE action status changes
	//    to COMPLETED. For more information, see Managing Storage Capacity (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html).
	AdministrativeActionType AdministrativeActionType `type:"string" enum:"true"`

	// Provides information about a failed administrative action.
	FailureDetails *AdministrativeActionFailureDetails `type:"structure"`

	// Provides the percent complete of a STORAGE_OPTIMIZATION administrative action.
	ProgressPercent *int64 `type:"integer"`

	// Time that the administrative action request was received.
	RequestTime *time.Time `type:"timestamp"`

	// Describes the status of the administrative action, as follows:
	//
	//    * FAILED - Amazon FSx failed to process the administrative action successfully.
	//
	//    * IN_PROGRESS - Amazon FSx is processing the administrative action.
	//
	//    * PENDING - Amazon FSx is waiting to process the administrative action.
	//
	//    * COMPLETED - Amazon FSx has finished processing the administrative task.
	//
	//    * UPDATED_OPTIMIZING - For a storage capacity increase update, Amazon
	//    FSx has updated the file system with the new storage capacity, and is
	//    now performing the storage optimization process. For more information,
	//    see Managing Storage Capacity (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html).
	Status Status `type:"string" enum:"true"`

	// Describes the target StorageCapacity or ThroughputCapacity value provided
	// in the UpdateFileSystem operation. Returned for FILE_SYSTEM_UPDATE administrative
	// actions.
	TargetFileSystemValues *FileSystem `type:"structure"`
}

// String returns the string representation
func (s AdministrativeAction) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a failed administrative action.
type AdministrativeActionFailureDetails struct {
	_ struct{} `type:"structure"`

	// Error message providing details about the failure.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AdministrativeActionFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// A backup of an Amazon FSx for file system.
type Backup struct {
	_ struct{} `type:"structure"`

	// The ID of the backup.
	//
	// BackupId is a required field
	BackupId *string `min:"12" type:"string" required:"true"`

	// The time when a particular backup was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The configuration of the self-managed Microsoft Active Directory (AD) to
	// which the Windows File Server instance is joined.
	DirectoryInformation *ActiveDirectoryBackupAttributes `type:"structure"`

	// Details explaining any failures that occur when creating a backup.
	FailureDetails *BackupFailureDetails `type:"structure"`

	// Metadata of the file system associated with the backup. This metadata is
	// persisted even if the file system is deleted.
	//
	// FileSystem is a required field
	FileSystem *FileSystem `type:"structure" required:"true"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt this
	// backup of the Amazon FSx for Windows file system's data at rest. Amazon FSx
	// for Lustre does not support KMS encryption.
	KmsKeyId *string `min:"1" type:"string"`

	// The lifecycle status of the backup.
	//
	// Lifecycle is a required field
	Lifecycle BackupLifecycle `type:"string" required:"true" enum:"true"`

	// The current percent of progress of an asynchronous task.
	ProgressPercent *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) for the backup resource.
	ResourceARN *string `min:"8" type:"string"`

	// Tags associated with a particular file system.
	Tags []Tag `min:"1" type:"list"`

	// The type of the backup.
	//
	// Type is a required field
	Type BackupType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s Backup) String() string {
	return awsutil.Prettify(s)
}

// If backup creation fails, this structure contains the details of that failure.
type BackupFailureDetails struct {
	_ struct{} `type:"structure"`

	// A message describing the backup creation failure.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BackupFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// Provides a report detailing the data repository task results of the files
// processed that match the criteria specified in the report Scope parameter.
// FSx delivers the report to the file system's linked data repository in Amazon
// S3, using the path specified in the report Path parameter. You can specify
// whether or not a report gets generated for a task using the Enabled parameter.
type CompletionReport struct {
	_ struct{} `type:"structure"`

	// Set Enabled to True to generate a CompletionReport when the task completes.
	// If set to true, then you need to provide a report Scope, Path, and Format.
	// Set Enabled to False if you do not want a CompletionReport generated when
	// the task completes.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`

	// Required if Enabled is set to true. Specifies the format of the CompletionReport.
	// REPORT_CSV_20191124 is the only format currently supported. When Format is
	// set to REPORT_CSV_20191124, the CompletionReport is provided in CSV format,
	// and is delivered to {path}/task-{id}/failures.csv.
	Format ReportFormat `type:"string" enum:"true"`

	// Required if Enabled is set to true. Specifies the location of the report
	// on the file system's linked S3 data repository. An absolute path that defines
	// where the completion report will be stored in the destination location. The
	// Path you provide must be located within the file system’s ExportPath. An
	// example Path value is "s3://myBucket/myExportPath/optionalPrefix". The report
	// provides the following information for each file in the report: FilePath,
	// FileStatus, and ErrorCode. To learn more about a file system's ExportPath,
	// see .
	Path *string `min:"3" type:"string"`

	// Required if Enabled is set to true. Specifies the scope of the CompletionReport;
	// FAILED_FILES_ONLY is the only scope currently supported. When Scope is set
	// to FAILED_FILES_ONLY, the CompletionReport only contains information about
	// files that the data repository task failed to process.
	Scope ReportScope `type:"string" enum:"true"`
}

// String returns the string representation
func (s CompletionReport) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompletionReport) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CompletionReport"}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}
	if s.Path != nil && len(*s.Path) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Path", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Lustre configuration for the file system being created.
type CreateFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	// The default is 0.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags for the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags for
	// the file system are copied to all automatic and user-initiated backups where
	// the user doesn't specify tags. If this value is true, and you specify one
	// or more tags, only the specified tags are copied to backups. If you specify
	// one or more tags when creating a user-initiated backup, no tags are copied
	// from the file system, regardless of this value.
	CopyTagsToBackups *bool `type:"boolean"`

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of
	// the day (0-23), and MM is the zero-padded minute of the hour. For example,
	// 05:00 specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// Choose SCRATCH_1 and SCRATCH_2 deployment types when you need temporary storage
	// and shorter-term processing of data. The SCRATCH_2 deployment type provides
	// in-transit encryption of data and higher burst throughput capacity than SCRATCH_1.
	//
	// This option can only be set for for PERSISTENT_1 deployments types.
	//
	// Choose PERSISTENT_1 deployment type for longer-term storage and workloads
	// and encryption of data in transit. To learn more about deployment types,
	// see FSx for Lustre Deployment Options (https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html).
	//
	// Encryption of data in-transit is automatically enabled when you access a
	// SCRATCH_2 or PERSISTENT_1 file system from Amazon EC2 instances that support
	// this feature (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/data- protection.html).
	// (Default = SCRATCH_1)
	//
	// Encryption of data in-transit for SCRATCH_2 and PERSISTENT_1 deployment types
	// is supported when accessed from supported instance types in supported AWS
	// Regions. To learn more, Encrypting Data in Transit (https://docs.aws.amazon.com/fsx/latest/LustreGuide/encryption-in-transit-fsxl.html).
	DeploymentType LustreDeploymentType `type:"string" enum:"true"`

	// (Optional) The path in Amazon S3 where the root of your Amazon FSx file system
	// is exported. The path must use the same Amazon S3 bucket as specified in
	// ImportPath. You can provide an optional prefix to which new and changed data
	// is to be exported from your Amazon FSx for Lustre file system. If an ExportPath
	// value is not provided, Amazon FSx sets a default export path, s3://import-bucket/FSxLustre[creation-timestamp].
	// The timestamp is in UTC format, for example s3://import-bucket/FSxLustre20181105T222312Z.
	//
	// The Amazon S3 export bucket must be the same as the import bucket specified
	// by ImportPath. If you only specify a bucket name, such as s3://import-bucket,
	// you get a 1:1 mapping of file system objects to S3 bucket objects. This mapping
	// means that the input data in S3 is overwritten on export. If you provide
	// a custom prefix in the export path, such as s3://import-bucket/[custom-optional-prefix],
	// Amazon FSx exports the contents of your file system to that export prefix
	// in the Amazon S3 bucket.
	ExportPath *string `min:"3" type:"string"`

	// (Optional) The path to the Amazon S3 bucket (including the optional prefix)
	// that you're using as the data repository for your Amazon FSx for Lustre file
	// system. The root of your FSx for Lustre file system will be mapped to the
	// root of the Amazon S3 bucket you select. An example is s3://import-bucket/optional-prefix.
	// If you specify a prefix after the Amazon S3 bucket name, only object keys
	// with that prefix are loaded into the file system.
	ImportPath *string `min:"3" type:"string"`

	// (Optional) For files imported from a data repository, this value determines
	// the stripe count and maximum amount of data per file (in MiB) stored on a
	// single physical disk. The maximum number of disks that a single file can
	// be striped across is limited by the total number of disks that make up the
	// file system.
	//
	// The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000
	// MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int64 `min:"1" type:"integer"`

	// Required for the PERSISTENT_1 deployment type, describes the amount of read
	// and write throughput for each 1 tebibyte of storage, in MB/s/TiB. File system
	// throughput capacity is calculated by multiplying ﬁle system storage capacity
	// (TiB) by the PerUnitStorageThroughput (MB/s/TiB). For a 2.4 TiB ﬁle system,
	// provisioning 50 MB/s/TiB of PerUnitStorageThroughput yields 117 MB/s of ﬁle
	// system throughput. You pay for the amount of throughput that you provision.
	//
	// Valid values are 50, 100, 200.
	PerUnitStorageThroughput *int64 `min:"50" type:"integer"`

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM
	// in the UTC time zone, where d is the weekday number, from 1 through 7, beginning
	// with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s CreateFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemLustreConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFileSystemLustreConfiguration"}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.ExportPath != nil && len(*s.ExportPath) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("ExportPath", 3))
	}
	if s.ImportPath != nil && len(*s.ImportPath) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("ImportPath", 3))
	}
	if s.ImportedFileChunkSize != nil && *s.ImportedFileChunkSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ImportedFileChunkSize", 1))
	}
	if s.PerUnitStorageThroughput != nil && *s.PerUnitStorageThroughput < 50 {
		invalidParams.Add(aws.NewErrParamMinValue("PerUnitStorageThroughput", 50))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration object for the Microsoft Windows file system used in CreateFileSystem
// and CreateFileSystemFromBackup operations.
type CreateFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID for an existing AWS Managed Microsoft Active Directory (AD) instance
	// that the file system should join when it's created.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The number of days to retain automatic backups. The default is to retain
	// backups for 7 days. Setting this value to 0 disables the creation of automatic
	// backups. The maximum retention period for backups is 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags for the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags for
	// the file system are copied to all automatic and user-initiated backups where
	// the user doesn't specify tags. If this value is true, and you specify one
	// or more tags, only the specified tags are copied to backups. If you specify
	// one or more tags when creating a user-initiated backup, no tags are copied
	// from the file system, regardless of this value.
	CopyTagsToBackups *bool `type:"boolean"`

	// The preferred time to take daily automatic backups, formatted HH:MM in the
	// UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// Specifies the file system deployment type, valid values are the following:
	//
	//    * MULTI_AZ_1 - Deploys a high availability file system that is configured
	//    for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability.
	//    You can only deploy a Multi-AZ file system in AWS Regions that have a
	//    minimum of three Availability Zones. Also supports HDD storage type
	//
	//    * SINGLE_AZ_1 - (Default) Choose to deploy a file system that is configured
	//    for single AZ redundancy.
	//
	//    * SINGLE_AZ_2 - The latest generation Single AZ file system. Specifies
	//    a file system that is configured for single AZ redundancy and supports
	//    HDD storage type.
	//
	// For more information, see Availability and Durability: Single-AZ and Multi-AZ
	// File Systems (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
	DeploymentType WindowsDeploymentType `type:"string" enum:"true"`

	// Required when DeploymentType is set to MULTI_AZ_1. This specifies the subnet
	// in which you want the preferred file server to be located. For in-AWS applications,
	// we recommend that you launch your clients in the same Availability Zone (AZ)
	// as your preferred file server to reduce cross-AZ data transfer costs and
	// minimize latency.
	PreferredSubnetId *string `min:"15" type:"string"`

	// The configuration that Amazon FSx uses to join the Windows File Server instance
	// to your self-managed (including on-premises) Microsoft Active Directory (AD)
	// directory.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfiguration `type:"structure"`

	// The throughput of an Amazon FSx file system, measured in megabytes per second,
	// in 2 to the nth increments, between 2^3 (8) and 2^11 (2048).
	//
	// ThroughputCapacity is a required field
	ThroughputCapacity *int64 `min:"8" type:"integer" required:"true"`

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM
	// in the UTC time zone, where d is the weekday number, from 1 through 7, beginning
	// with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s CreateFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemWindowsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFileSystemWindowsConfiguration"}
	if s.ActiveDirectoryId != nil && len(*s.ActiveDirectoryId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("ActiveDirectoryId", 12))
	}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.PreferredSubnetId != nil && len(*s.PreferredSubnetId) < 15 {
		invalidParams.Add(aws.NewErrParamMinLen("PreferredSubnetId", 15))
	}

	if s.ThroughputCapacity == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThroughputCapacity"))
	}
	if s.ThroughputCapacity != nil && *s.ThroughputCapacity < 8 {
		invalidParams.Add(aws.NewErrParamMinValue("ThroughputCapacity", 8))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}
	if s.SelfManagedActiveDirectoryConfiguration != nil {
		if err := s.SelfManagedActiveDirectoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SelfManagedActiveDirectoryConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The data repository configuration object for Lustre file systems returned
// in the response of the CreateFileSystem operation.
type DataRepositoryConfiguration struct {
	_ struct{} `type:"structure"`

	// The export path to the Amazon S3 bucket (and prefix) that you are using to
	// store new and changed Lustre file system files in S3.
	ExportPath *string `min:"3" type:"string"`

	// The import path to the Amazon S3 bucket (and optional prefix) that you're
	// using as the data repository for your FSx for Lustre file system, for example
	// s3://import-bucket/optional-prefix. If a prefix is specified after the Amazon
	// S3 bucket name, only object keys with that prefix are loaded into the file
	// system.
	ImportPath *string `min:"3" type:"string"`

	// For files imported from a data repository, this value determines the stripe
	// count and maximum amount of data per file (in MiB) stored on a single physical
	// disk. The maximum number of disks that a single file can be striped across
	// is limited by the total number of disks that make up the file system.
	//
	// The default chunk size is 1,024 MiB (1 GiB) and can go as high as 512,000
	// MiB (500 GiB). Amazon S3 objects have a maximum size of 5 TB.
	ImportedFileChunkSize *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s DataRepositoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// A description of the data repository task. You use data repository tasks
// to perform bulk transfer operations between your Amazon FSx file system and
// its linked data repository.
type DataRepositoryTask struct {
	_ struct{} `type:"structure"`

	// The time that the resource was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The time that Amazon FSx completed processing the task, populated after the
	// task is complete.
	EndTime *time.Time `type:"timestamp"`

	// Failure message describing why the task failed, it is populated only when
	// Lifecycle is set to FAILED.
	FailureDetails *DataRepositoryTaskFailureDetails `type:"structure"`

	// The globally unique ID of the file system, assigned by Amazon FSx.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The lifecycle status of the data repository task, as follows:
	//
	//    * PENDING - Amazon FSx has not started the task.
	//
	//    * EXECUTING - Amazon FSx is processing the task.
	//
	//    * FAILED - Amazon FSx was not able to complete the task. For example,
	//    there may be files the task failed to process. The DataRepositoryTaskFailureDetails
	//    property provides more information about task failures.
	//
	//    * SUCCEEDED - FSx completed the task successfully.
	//
	//    * CANCELED - Amazon FSx canceled the task and it did not complete.
	//
	//    * CANCELING - FSx is in process of canceling the task.
	//
	// You cannot delete an FSx for Lustre file system if there are data repository
	// tasks for the file system in the PENDING or EXECUTING states. Please retry
	// when the data repository task is finished (with a status of CANCELED, SUCCEEDED,
	// or FAILED). You can use the DescribeDataRepositoryTask action to monitor
	// the task status. Contact the FSx team if you need to delete your file system
	// immediately.
	//
	// Lifecycle is a required field
	Lifecycle DataRepositoryTaskLifecycle `type:"string" required:"true" enum:"true"`

	// An array of paths on the Amazon FSx for Lustre file system that specify the
	// data for the data repository task to process. For example, in an EXPORT_TO_REPOSITORY
	// task, the paths specify which data to export to the linked data repository.
	//
	// (Default) If Paths is not specified, Amazon FSx uses the file system root
	// directory.
	Paths []string `type:"list"`

	// Provides a report detailing the data repository task results of the files
	// processed that match the criteria specified in the report Scope parameter.
	// FSx delivers the report to the file system's linked data repository in Amazon
	// S3, using the path specified in the report Path parameter. You can specify
	// whether or not a report gets generated for a task using the Enabled parameter.
	Report *CompletionReport `type:"structure"`

	// The Amazon Resource Name (ARN) for a given resource. ARNs uniquely identify
	// AWS resources. We require an ARN when you need to specify a resource unambiguously
	// across all of AWS. For more information, see Amazon Resource Names (ARNs)
	// and AWS Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	ResourceARN *string `min:"8" type:"string"`

	// The time that Amazon FSx began processing the task.
	StartTime *time.Time `type:"timestamp"`

	// Provides the status of the number of files that the task has processed successfully
	// and failed to process.
	Status *DataRepositoryTaskStatus `type:"structure"`

	// A list of Tag values, with a maximum of 50 elements.
	Tags []Tag `min:"1" type:"list"`

	// The system-generated, unique 17-digit ID of the data repository task.
	//
	// TaskId is a required field
	TaskId *string `min:"12" type:"string" required:"true"`

	// The type of data repository task; EXPORT_TO_REPOSITORY is the only type currently
	// supported.
	//
	// Type is a required field
	Type DataRepositoryTaskType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DataRepositoryTask) String() string {
	return awsutil.Prettify(s)
}

// Provides information about why a data repository task failed. Only populated
// when the task Lifecycle is set to FAILED.
type DataRepositoryTaskFailureDetails struct {
	_ struct{} `type:"structure"`

	// A detailed error message.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DataRepositoryTaskFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// (Optional) An array of filter objects you can use to filter the response
// of data repository tasks you will see in the the response. You can filter
// the tasks returned in the response by one or more file system IDs, task lifecycles,
// and by task type. A filter object consists of a filter Name, and one or more
// Values for the filter.
type DataRepositoryTaskFilter struct {
	_ struct{} `type:"structure"`

	// Name of the task property to use in filtering the tasks returned in the response.
	//
	//    * Use file-system-id to retrieve data repository tasks for specific file
	//    systems.
	//
	//    * Use task-lifecycle to retrieve data repository tasks with one or more
	//    specific lifecycle states, as follows: CANCELED, EXECUTING, FAILED, PENDING,
	//    and SUCCEEDED.
	Name DataRepositoryTaskFilterName `type:"string" enum:"true"`

	// Use Values to include the specific file system IDs and task lifecycle states
	// for the filters you are using.
	Values []string `type:"list"`
}

// String returns the string representation
func (s DataRepositoryTaskFilter) String() string {
	return awsutil.Prettify(s)
}

// Provides the task status showing a running total of the total number of files
// to be processed, the number successfully processed, and the number of files
// the task failed to process.
type DataRepositoryTaskStatus struct {
	_ struct{} `type:"structure"`

	// A running total of the number of files that the task failed to process.
	FailedCount *int64 `type:"long"`

	// The time at which the task status was last updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// A running total of the number of files that the task has successfully processed.
	SucceededCount *int64 `type:"long"`

	// The total number of files that the task will process. While a task is executing,
	// the sum of SucceededCount plus FailedCount may not equal TotalCount. When
	// the task is complete, TotalCount equals the sum of SucceededCount plus FailedCount.
	TotalCount *int64 `type:"long"`
}

// String returns the string representation
func (s DataRepositoryTaskStatus) String() string {
	return awsutil.Prettify(s)
}

// The configuration object for the Amazon FSx for Lustre file system being
// deleted in the DeleteFileSystem operation.
type DeleteFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// Use if SkipFinalBackup is set to false, and you want to apply an array of
	// tags to the final backup. If you have set the file system property CopyTagsToBackups
	// to true, and you specify one or more FinalBackupTags when deleting a file
	// system, Amazon FSx will not copy any existing file system tags to the backup.
	FinalBackupTags []Tag `min:"1" type:"list"`

	// Set SkipFinalBackup to false if you want to take a final backup of the file
	// system you are deleting. By default, Amazon FSx will not take a final backup
	// on your behalf when the DeleteFileSystem operation is invoked. (Default =
	// true)
	SkipFinalBackup *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemLustreConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFileSystemLustreConfiguration"}
	if s.FinalBackupTags != nil && len(s.FinalBackupTags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FinalBackupTags", 1))
	}
	if s.FinalBackupTags != nil {
		for i, v := range s.FinalBackupTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FinalBackupTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response object for the Amazon FSx for Lustre file system being deleted
// in the DeleteFileSystem operation.
type DeleteFileSystemLustreResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the final backup for this file system.
	FinalBackupId *string `min:"12" type:"string"`

	// The set of tags applied to the final backup.
	FinalBackupTags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s DeleteFileSystemLustreResponse) String() string {
	return awsutil.Prettify(s)
}

// The configuration object for the Microsoft Windows file system used in the
// DeleteFileSystem operation.
type DeleteFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// A set of tags for your final backup.
	FinalBackupTags []Tag `min:"1" type:"list"`

	// By default, Amazon FSx for Windows takes a final backup on your behalf when
	// the DeleteFileSystem operation is invoked. Doing this helps protect you from
	// data loss, and we highly recommend taking the final backup. If you want to
	// skip this backup, use this flag to do so.
	SkipFinalBackup *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemWindowsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteFileSystemWindowsConfiguration"}
	if s.FinalBackupTags != nil && len(s.FinalBackupTags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FinalBackupTags", 1))
	}
	if s.FinalBackupTags != nil {
		for i, v := range s.FinalBackupTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FinalBackupTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response object for the Microsoft Windows file system used in the DeleteFileSystem
// operation.
type DeleteFileSystemWindowsResponse struct {
	_ struct{} `type:"structure"`

	// The ID of the final backup for this file system.
	FinalBackupId *string `min:"12" type:"string"`

	// The set of tags applied to the final backup.
	FinalBackupTags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s DeleteFileSystemWindowsResponse) String() string {
	return awsutil.Prettify(s)
}

// A description of a specific Amazon FSx file system.
type FileSystem struct {
	_ struct{} `type:"structure"`

	// A list of administrative actions for the file system that are in process
	// or waiting to be processed. Administrative actions describe changes to the
	// Windows file system that you have initiated using the UpdateFileSystem action.
	AdministrativeActions []AdministrativeAction `type:"list"`

	// The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z),
	// also known as Unix time.
	CreationTime *time.Time `type:"timestamp"`

	// The DNS name for the file system.
	DNSName *string `min:"16" type:"string"`

	// A structure providing details of any failures that occur when creating the
	// file system has failed.
	FailureDetails *FileSystemFailureDetails `type:"structure"`

	// The system-generated, unique 17-digit ID of the file system.
	FileSystemId *string `min:"11" type:"string"`

	// The type of Amazon FSx file system, either LUSTRE or WINDOWS.
	FileSystemType FileSystemType `type:"string" enum:"true"`

	// The ID of the AWS Key Management Service (AWS KMS) key used to encrypt the
	// file system's data for Amazon FSx for Windows File Server file systems and
	// persistent Amazon FSx for Lustre file systems at rest. In either case, if
	// not specified, the Amazon FSx managed key is used. The scratch Amazon FSx
	// for Lustre file systems are always encrypted at rest using Amazon FSx managed
	// keys. For more information, see Encrypt (https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html)
	// in the AWS Key Management Service API Reference.
	KmsKeyId *string `min:"1" type:"string"`

	// The lifecycle status of the file system, following are the possible values
	// and what they mean:
	//
	//    * AVAILABLE - The file system is in a healthy state, and is reachable
	//    and available for use.
	//
	//    * CREATING - Amazon FSx is creating the new file system.
	//
	//    * DELETING - Amazon FSx is deleting an existing file system.
	//
	//    * FAILED - An existing file system has experienced an unrecoverable failure.
	//    When creating a new file system, Amazon FSx was unable to create the file
	//    system.
	//
	//    * MISCONFIGURED indicates that the file system is in a failed but recoverable
	//    state.
	//
	//    * UPDATING indicates that the file system is undergoing a customer initiated
	//    update.
	Lifecycle FileSystemLifecycle `type:"string" enum:"true"`

	// The configuration for the Amazon FSx for Lustre file system.
	LustreConfiguration *LustreFileSystemConfiguration `type:"structure"`

	// The IDs of the elastic network interface from which a specific file system
	// is accessible. The elastic network interface is automatically created in
	// the same VPC that the Amazon FSx file system was created in. For more information,
	// see Elastic Network Interfaces (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html)
	// in the Amazon EC2 User Guide.
	//
	// For an Amazon FSx for Windows File Server file system, you can have one network
	// interface ID. For an Amazon FSx for Lustre file system, you can have more
	// than one.
	NetworkInterfaceIds []string `type:"list"`

	// The AWS account that created the file system. If the file system was created
	// by an AWS Identity and Access Management (IAM) user, the AWS account to which
	// the IAM user belongs is the owner.
	OwnerId *string `min:"12" type:"string"`

	// The Amazon Resource Name (ARN) for the file system resource.
	ResourceARN *string `min:"8" type:"string"`

	// The storage capacity of the file system in gigabytes (GB).
	StorageCapacity *int64 `type:"integer"`

	// The storage type of the file system. Valid values are SSD and HDD. If set
	// to SSD, the file system uses solid state drive storage. If set to HDD, the
	// file system uses hard disk drive storage.
	StorageType StorageType `type:"string" enum:"true"`

	// Specifies the IDs of the subnets that the file system is accessible from.
	// For Windows MULTI_AZ_1 file system deployment type, there are two subnet
	// IDs, one for the preferred file server and one for the standby file server.
	// The preferred file server subnet identified in the PreferredSubnetID property.
	// All other file systems have only one subnet ID.
	//
	// For Lustre file systems, and Single-AZ Windows file systems, this is the
	// ID of the subnet that contains the endpoint for the file system. For MULTI_AZ_1
	// Windows file systems, the endpoint for the file system is available in the
	// PreferredSubnetID.
	SubnetIds []string `type:"list"`

	// The tags to associate with the file system. For more information, see Tagging
	// Your Amazon EC2 Resources (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
	// in the Amazon EC2 User Guide.
	Tags []Tag `min:"1" type:"list"`

	// The ID of the primary VPC for the file system.
	VpcId *string `min:"12" type:"string"`

	// The configuration for this Microsoft Windows file system.
	WindowsConfiguration *WindowsFileSystemConfiguration `type:"structure"`
}

// String returns the string representation
func (s FileSystem) String() string {
	return awsutil.Prettify(s)
}

// A structure providing details of any failures that occur when creating the
// file system has failed.
type FileSystemFailureDetails struct {
	_ struct{} `type:"structure"`

	// A message describing any failures that occurred during file system creation.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s FileSystemFailureDetails) String() string {
	return awsutil.Prettify(s)
}

// A filter used to restrict the results of describe calls. You can use multiple
// filters to return results that meet all applied filter requirements.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name for this filter.
	Name FilterName `type:"string" enum:"true"`

	// The values of the filter. These are all the values for any of the applied
	// filters.
	Values []string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// The configuration for the Amazon FSx for Lustre file system.
type LustreFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	// The default is 0.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags on the file system should be copied
	// to backups. If it's set to true, all tags on the file system are copied to
	// all automatic backups and any user-initiated backups where the user doesn't
	// specify any tags. If this value is true, and you specify one or more tags,
	// only the specified tags are copied to backups. If you specify one or more
	// tags when creating a user-initiated backup, no tags are copied from the file
	// system, regardless of this value. (Default = false)
	CopyTagsToBackups *bool `type:"boolean"`

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of
	// the day (0-23), and MM is the zero-padded minute of the hour. For example,
	// 05:00 specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The data repository configuration object for Lustre file systems returned
	// in the response of the CreateFileSystem operation.
	DataRepositoryConfiguration *DataRepositoryConfiguration `type:"structure"`

	// The deployment type of the FSX for Lustre file system. Scratch deployment
	// type is designed for temporary storage and shorter-term processing of data.
	//
	// SCRATCH_1 and SCRATCH_2 deployment types are best suited for when you need
	// temporary storage and shorter-term processing of data. The SCRATCH_2 deployment
	// type provides in-transit encryption of data and higher burst throughput capacity
	// than SCRATCH_1.
	//
	// The PERSISTENT_1 deployment type is used for longer-term storage and workloads
	// and encryption of data in transit. To learn more about deployment types,
	// see FSx for Lustre Deployment Options (https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-deployment-types.html).
	// (Default = SCRATCH_1)
	DeploymentType LustreDeploymentType `type:"string" enum:"true"`

	// You use the MountName value when mounting the file system.
	//
	// For the SCRATCH_1 deployment type, this value is always "fsx". For SCRATCH_2
	// and PERSISTENT_1 deployment types, this value is a string that is unique
	// within an AWS Region.
	MountName *string `min:"1" type:"string"`

	// Per unit storage throughput represents the megabytes per second of read or
	// write throughput per 1 tebibyte of storage provisioned. File system throughput
	// capacity is equal to Storage capacity (TiB) * PerUnitStorageThroughput (MB/s/TiB).
	// This option is only valid for PERSISTENT_1 deployment types. Valid values
	// are 50, 100, 200.
	PerUnitStorageThroughput *int64 `min:"50" type:"integer"`

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM
	// in the UTC time zone. d is the weekday number, from 1 through 7, beginning
	// with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s LustreFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}

// The configuration of the self-managed Microsoft Active Directory (AD) directory
// to which the Windows File Server instance is joined.
type SelfManagedActiveDirectoryAttributes struct {
	_ struct{} `type:"structure"`

	// A list of up to two IP addresses of DNS servers or domain controllers in
	// the self-managed AD directory.
	DnsIps []string `min:"1" type:"list"`

	// The fully qualified domain name of the self-managed AD directory.
	DomainName *string `min:"1" type:"string"`

	// The name of the domain group whose members have administrative privileges
	// for the FSx file system.
	FileSystemAdministratorsGroup *string `min:"1" type:"string"`

	// The fully qualified distinguished name of the organizational unit within
	// the self-managed AD directory to which the Windows File Server instance is
	// joined.
	OrganizationalUnitDistinguishedName *string `min:"1" type:"string"`

	// The user name for the service account on your self-managed AD domain that
	// FSx uses to join to your AD domain.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SelfManagedActiveDirectoryAttributes) String() string {
	return awsutil.Prettify(s)
}

// The configuration that Amazon FSx uses to join the Windows File Server instance
// to your self-managed (including on-premises) Microsoft Active Directory (AD)
// directory.
type SelfManagedActiveDirectoryConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of up to two IP addresses of DNS servers or domain controllers in
	// the self-managed AD directory. The IP addresses need to be either in the
	// same VPC CIDR range as the one in which your Amazon FSx file system is being
	// created, or in the private IP version 4 (IPv4) address ranges, as specified
	// in RFC 1918 (http://www.faqs.org/rfcs/rfc1918.html):
	//
	//    * 10.0.0.0 - 10.255.255.255 (10/8 prefix)
	//
	//    * 172.16.0.0 - 172.31.255.255 (172.16/12 prefix)
	//
	//    * 192.168.0.0 - 192.168.255.255 (192.168/16 prefix)
	//
	// DnsIps is a required field
	DnsIps []string `min:"1" type:"list" required:"true"`

	// The fully qualified domain name of the self-managed AD directory, such as
	// corp.example.com.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// (Optional) The name of the domain group whose members are granted administrative
	// privileges for the file system. Administrative privileges include taking
	// ownership of files and folders, setting audit controls (audit ACLs) on files
	// and folders, and administering the file system remotely by using the FSx
	// Remote PowerShell. The group that you specify must already exist in your
	// domain. If you don't provide one, your AD domain's Domain Admins group is
	// used.
	FileSystemAdministratorsGroup *string `min:"1" type:"string"`

	// (Optional) The fully qualified distinguished name of the organizational unit
	// within your self-managed AD directory that the Windows File Server instance
	// will join. Amazon FSx only accepts OU as the direct parent of the file system.
	// An example is OU=FSx,DC=yourdomain,DC=corp,DC=com. To learn more, see RFC
	// 2253 (https://tools.ietf.org/html/rfc2253). If none is provided, the FSx
	// file system is created in the default location of your self-managed AD directory.
	//
	// Only Organizational Unit (OU) objects can be the direct parent of the file
	// system that you're creating.
	OrganizationalUnitDistinguishedName *string `min:"1" type:"string"`

	// The password for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The user name for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain. This account must have the
	// permission to join computers to the domain in the organizational unit provided
	// in OrganizationalUnitDistinguishedName, or in the default location of your
	// AD domain.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SelfManagedActiveDirectoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelfManagedActiveDirectoryConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SelfManagedActiveDirectoryConfiguration"}

	if s.DnsIps == nil {
		invalidParams.Add(aws.NewErrParamRequired("DnsIps"))
	}
	if s.DnsIps != nil && len(s.DnsIps) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DnsIps", 1))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 1))
	}
	if s.FileSystemAdministratorsGroup != nil && len(*s.FileSystemAdministratorsGroup) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileSystemAdministratorsGroup", 1))
	}
	if s.OrganizationalUnitDistinguishedName != nil && len(*s.OrganizationalUnitDistinguishedName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OrganizationalUnitDistinguishedName", 1))
	}

	if s.Password == nil {
		invalidParams.Add(aws.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Password", 1))
	}

	if s.UserName == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration that Amazon FSx uses to join the Windows File Server instance
// to a self-managed Microsoft Active Directory (AD) directory.
type SelfManagedActiveDirectoryConfigurationUpdates struct {
	_ struct{} `type:"structure"`

	// A list of up to two IP addresses of DNS servers or domain controllers in
	// the self-managed AD directory.
	DnsIps []string `min:"1" type:"list"`

	// The password for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain.
	Password *string `min:"1" type:"string" sensitive:"true"`

	// The user name for the service account on your self-managed AD domain that
	// Amazon FSx will use to join to your AD domain. This account must have the
	// permission to join computers to the domain in the organizational unit provided
	// in OrganizationalUnitDistinguishedName.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SelfManagedActiveDirectoryConfigurationUpdates) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelfManagedActiveDirectoryConfigurationUpdates) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SelfManagedActiveDirectoryConfigurationUpdates"}
	if s.DnsIps != nil && len(s.DnsIps) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DnsIps", 1))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Password", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a key-value pair for a resource tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// A value that specifies the TagKey, the name of the tag. Tag keys must be
	// unique for the resource to which they are attached.
	Key *string `min:"1" type:"string"`

	// A value that specifies the TagValue, the value assigned to the corresponding
	// tag key. Tag values can be null and don't have to be unique in a tag set.
	// For example, you can have a key-value pair in a tag set of finances : April
	// and also of payroll : April.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration object for Amazon FSx for Lustre file systems used in the
// UpdateFileSystem operation.
type UpdateFileSystemLustreConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	// The default is 0.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A recurring daily time, in the format HH:MM. HH is the zero-padded hour of
	// the day (0-23), and MM is the zero-padded minute of the hour. For example,
	// 05:00 specifies 5 AM daily.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM
	// in the UTC time zone. d is the weekday number, from 1 through 7, beginning
	// with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s UpdateFileSystemLustreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemLustreConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFileSystemLustreConfiguration"}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Updates the configuration for an existing Amazon FSx for Windows File Server
// file system. Amazon FSx only overwrites existing properties with non-null
// values provided in the request.
type UpdateFileSystemWindowsConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of days to retain automatic daily backups. Setting this to zero
	// (0) disables automatic daily backups. You can retain automatic daily backups
	// for a maximum of 35 days. For more information, see Working with Automatic
	// Daily Backups (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/using-backups.html#automatic-backups).
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// The preferred time to start the daily automatic backup, in the UTC time zone,
	// for example, 02:00
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// The configuration Amazon FSx uses to join the Windows File Server instance
	// to the self-managed Microsoft AD directory. You cannot make a self-managed
	// Microsoft AD update request if there is an existing self-managed Microsoft
	// AD update request in progress.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryConfigurationUpdates `type:"structure"`

	// Sets the target value for a file system's throughput capacity, in MB/s, that
	// you are updating the file system to. Valid values are 8, 16, 32, 64, 128,
	// 256, 512, 1024, 2048. You cannot make a throughput capacity update request
	// if there is an existing throughput capacity update request in progress. For
	// more information, see Managing Throughput Capacity (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-throughput-capacity.html).
	ThroughputCapacity *int64 `min:"8" type:"integer"`

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM
	// in the UTC time zone. Where d is the weekday number, from 1 through 7, with
	// 1 = Monday and 7 = Sunday.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s UpdateFileSystemWindowsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemWindowsConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFileSystemWindowsConfiguration"}
	if s.DailyAutomaticBackupStartTime != nil && len(*s.DailyAutomaticBackupStartTime) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("DailyAutomaticBackupStartTime", 5))
	}
	if s.ThroughputCapacity != nil && *s.ThroughputCapacity < 8 {
		invalidParams.Add(aws.NewErrParamMinValue("ThroughputCapacity", 8))
	}
	if s.WeeklyMaintenanceStartTime != nil && len(*s.WeeklyMaintenanceStartTime) < 7 {
		invalidParams.Add(aws.NewErrParamMinLen("WeeklyMaintenanceStartTime", 7))
	}
	if s.SelfManagedActiveDirectoryConfiguration != nil {
		if err := s.SelfManagedActiveDirectoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SelfManagedActiveDirectoryConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The configuration for this Microsoft Windows file system.
type WindowsFileSystemConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID for an existing Microsoft Active Directory instance that the file
	// system should join when it's created.
	ActiveDirectoryId *string `min:"12" type:"string"`

	// The number of days to retain automatic backups. Setting this to 0 disables
	// automatic backups. You can retain automatic backups for a maximum of 35 days.
	AutomaticBackupRetentionDays *int64 `type:"integer"`

	// A boolean flag indicating whether tags on the file system should be copied
	// to backups. This value defaults to false. If it's set to true, all tags on
	// the file system are copied to all automatic backups and any user-initiated
	// backups where the user doesn't specify any tags. If this value is true, and
	// you specify one or more tags, only the specified tags are copied to backups.
	// If you specify one or more tags when creating a user-initiated backup, no
	// tags are copied from the file system, regardless of this value.
	CopyTagsToBackups *bool `type:"boolean"`

	// The preferred time to take daily automatic backups, in the UTC time zone.
	DailyAutomaticBackupStartTime *string `min:"5" type:"string"`

	// Specifies the file system deployment type, valid values are the following:
	//
	//    * MULTI_AZ_1 - Specifies a high availability file system that is configured
	//    for Multi-AZ redundancy to tolerate temporary Availability Zone (AZ) unavailability,
	//    and supports SSD and HDD storage.
	//
	//    * SINGLE_AZ_1 - (Default) Specifies a file system that is configured for
	//    single AZ redundancy, only supports SSD storage.
	//
	//    * SINGLE_AZ_2 - Latest generation Single AZ file system. Specifies a file
	//    system that is configured for single AZ redundancy and supports SSD and
	//    HDD storage.
	//
	// For more information, see Single-AZ and Multi-AZ File Systems (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html).
	DeploymentType WindowsDeploymentType `type:"string" enum:"true"`

	// The list of maintenance operations in progress for this file system.
	MaintenanceOperationsInProgress []FileSystemMaintenanceOperation `type:"list"`

	// For MULTI_AZ_1 deployment types, the IP address of the primary, or preferred,
	// file server.
	//
	// Use this IP address when mounting the file system on Linux SMB clients or
	// Windows SMB clients that are not joined to a Microsoft Active Directory.
	// Applicable for all Windows file system deployment types. This IP address
	// is temporarily unavailable when the file system is undergoing maintenance.
	// For Linux and Windows SMB clients that are joined to an Active Directory,
	// use the file system's DNSName instead. For more information on mapping and
	// mounting file shares, see Accessing File Shares (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/accessing-file-shares.html).
	PreferredFileServerIp *string `min:"7" type:"string"`

	// For MULTI_AZ_1 deployment types, it specifies the ID of the subnet where
	// the preferred file server is located. Must be one of the two subnet IDs specified
	// in SubnetIds property. Amazon FSx serves traffic from this subnet except
	// in the event of a failover to the secondary file server.
	//
	// For SINGLE_AZ_1 and SINGLE_AZ_2 deployment types, this value is the same
	// as that for SubnetIDs. For more information, see Availability and Durability:
	// Single-AZ and Multi-AZ File Systems (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html#single-multi-az-resources)
	PreferredSubnetId *string `min:"15" type:"string"`

	// For MULTI_AZ_1 deployment types, use this endpoint when performing administrative
	// tasks on the file system using Amazon FSx Remote PowerShell.
	//
	// For SINGLE_AZ_1 and SINGLE_AZ_2 deployment types, this is the DNS name of
	// the file system.
	//
	// This endpoint is temporarily unavailable when the file system is undergoing
	// maintenance.
	RemoteAdministrationEndpoint *string `min:"16" type:"string"`

	// The configuration of the self-managed Microsoft Active Directory (AD) directory
	// to which the Windows File Server instance is joined.
	SelfManagedActiveDirectoryConfiguration *SelfManagedActiveDirectoryAttributes `type:"structure"`

	// The throughput of an Amazon FSx file system, measured in megabytes per second.
	ThroughputCapacity *int64 `min:"8" type:"integer"`

	// The preferred start time to perform weekly maintenance, formatted d:HH:MM
	// in the UTC time zone. d is the weekday number, from 1 through 7, beginning
	// with Monday and ending with Sunday.
	WeeklyMaintenanceStartTime *string `min:"7" type:"string"`
}

// String returns the string representation
func (s WindowsFileSystemConfiguration) String() string {
	return awsutil.Prettify(s)
}
