// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request object for the CreateBackup operation.
type CreateBackupInput struct {
	_ struct{} `type:"structure"`

	// A string of up to 64 ASCII characters that Amazon FSx uses to ensure idempotent
	// creation. This string is automatically filled on your behalf when you use
	// the AWS Command Line Interface (AWS CLI) or an AWS SDK.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the file system to back up.
	//
	// FileSystemId is a required field
	FileSystemId *string `min:"11" type:"string" required:"true"`

	// The tags to apply to the backup at backup creation. The key value of the
	// Name tag appears in the console as the backup name. If you have set CopyTagsToBackups
	// to true, and you specify one or more tags using the CreateBackup action,
	// no existing tags on the file system are copied from the file system to the
	// backup.
	Tags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateBackupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateBackupInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.FileSystemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 11 {
		invalidParams.Add(aws.NewErrParamMinLen("FileSystemId", 11))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response object for the CreateBackup operation.
type CreateBackupOutput struct {
	_ struct{} `type:"structure"`

	// A description of the backup.
	Backup *Backup `type:"structure"`
}

// String returns the string representation
func (s CreateBackupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateBackup = "CreateBackup"

// CreateBackupRequest returns a request value for making API operation for
// Amazon FSx.
//
// Creates a backup of an existing Amazon FSx file system. Creating regular
// backups for your file system is a best practice, enabling you to restore
// a file system from a backup if an issue arises with the original file system.
//
// For Amazon FSx for Lustre file systems, you can create a backup only for
// file systems with the following configuration:
//
//    * a Persistent deployment type
//
//    * is not linked to an Amazon S3 data respository.
//
// For more information, see https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-backups.html
// (https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-backups.html).
//
// If a backup with the specified client request token exists, and the parameters
// match, this operation returns the description of the existing backup. If
// a backup specified client request token exists, and the parameters don't
// match, this operation returns IncompatibleParameterError. If a backup with
// the specified client request token doesn't exist, CreateBackup does the following:
//
//    * Creates a new Amazon FSx backup with an assigned ID, and an initial
//    lifecycle state of CREATING.
//
//    * Returns the description of the backup.
//
// By using the idempotent operation, you can retry a CreateBackup operation
// without the risk of creating an extra backup. This approach can be useful
// when an initial call fails in a way that makes it unclear whether a backup
// was created. If you use the same client request token and the initial call
// created a backup, the operation returns a successful result because all the
// parameters are the same.
//
// The CreateBackup operation returns while the backup's lifecycle state is
// still CREATING. You can check the backup creation status by calling the DescribeBackups
// operation, which returns the backup state along with other information.
//
//    // Example sending a request using CreateBackupRequest.
//    req := client.CreateBackupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fsx-2018-03-01/CreateBackup
func (c *Client) CreateBackupRequest(input *CreateBackupInput) CreateBackupRequest {
	op := &aws.Operation{
		Name:       opCreateBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBackupInput{}
	}

	req := c.newRequest(op, input, &CreateBackupOutput{})

	return CreateBackupRequest{Request: req, Input: input, Copy: c.CreateBackupRequest}
}

// CreateBackupRequest is the request type for the
// CreateBackup API operation.
type CreateBackupRequest struct {
	*aws.Request
	Input *CreateBackupInput
	Copy  func(*CreateBackupInput) CreateBackupRequest
}

// Send marshals and sends the CreateBackup API request.
func (r CreateBackupRequest) Send(ctx context.Context) (*CreateBackupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateBackupResponse{
		CreateBackupOutput: r.Request.Data.(*CreateBackupOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateBackupResponse is the response type for the
// CreateBackup API operation.
type CreateBackupResponse struct {
	*CreateBackupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateBackup request.
func (r *CreateBackupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
