// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fsx

// The type of error relating to Microsoft Active Directory. NOT_FOUND means
// that no directory was found by specifying the given directory. INCOMPATIBLE_MODE
// means that the directory specified is not a Microsoft AD directory. WRONG_VPC
// means that the specified directory isn't accessible from the specified VPC.
// WRONG_STAGE means that the specified directory isn't currently in the ACTIVE
// state.
type ActiveDirectoryErrorType string

// Enum values for ActiveDirectoryErrorType
const (
	ActiveDirectoryErrorTypeDomainNotFound         ActiveDirectoryErrorType = "DOMAIN_NOT_FOUND"
	ActiveDirectoryErrorTypeIncompatibleDomainMode ActiveDirectoryErrorType = "INCOMPATIBLE_DOMAIN_MODE"
	ActiveDirectoryErrorTypeWrongVpc               ActiveDirectoryErrorType = "WRONG_VPC"
	ActiveDirectoryErrorTypeInvalidDomainStage     ActiveDirectoryErrorType = "INVALID_DOMAIN_STAGE"
)

func (enum ActiveDirectoryErrorType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ActiveDirectoryErrorType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// Describes the type of administrative action, as follows:
//
//    * FILE_SYSTEM_UPDATE - A file system update administrative action initiated
//    by the user from the Amazon FSx console, API (UpdateFileSystem), or CLI
//    (update-file-system). A
//
//    * STORAGE_OPTIMIZATION - Once the FILE_SYSTEM_UPDATE task to increase
//    a file system's storage capacity completes successfully, a STORAGE_OPTIMIZATION
//    task starts. Storage optimization is the process of migrating the file
//    system data to the new, larger disks. You can track the storage migration
//    progress using the ProgressPercent property. When STORAGE_OPTIMIZATION
//    completes successfully, the parent FILE_SYSTEM_UPDATE action status changes
//    to COMPLETED. For more information, see Managing Storage Capacity (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html).
type AdministrativeActionType string

// Enum values for AdministrativeActionType
const (
	AdministrativeActionTypeFileSystemUpdate    AdministrativeActionType = "FILE_SYSTEM_UPDATE"
	AdministrativeActionTypeStorageOptimization AdministrativeActionType = "STORAGE_OPTIMIZATION"
)

func (enum AdministrativeActionType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum AdministrativeActionType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The lifecycle status of the backup.
type BackupLifecycle string

// Enum values for BackupLifecycle
const (
	BackupLifecycleAvailable BackupLifecycle = "AVAILABLE"
	BackupLifecycleCreating  BackupLifecycle = "CREATING"
	BackupLifecycleDeleted   BackupLifecycle = "DELETED"
	BackupLifecycleFailed    BackupLifecycle = "FAILED"
)

func (enum BackupLifecycle) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BackupLifecycle) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The type of the backup.
type BackupType string

// Enum values for BackupType
const (
	BackupTypeAutomatic     BackupType = "AUTOMATIC"
	BackupTypeUserInitiated BackupType = "USER_INITIATED"
)

func (enum BackupType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum BackupType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type DataRepositoryTaskFilterName string

// Enum values for DataRepositoryTaskFilterName
const (
	DataRepositoryTaskFilterNameFileSystemId  DataRepositoryTaskFilterName = "file-system-id"
	DataRepositoryTaskFilterNameTaskLifecycle DataRepositoryTaskFilterName = "task-lifecycle"
)

func (enum DataRepositoryTaskFilterName) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DataRepositoryTaskFilterName) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type DataRepositoryTaskLifecycle string

// Enum values for DataRepositoryTaskLifecycle
const (
	DataRepositoryTaskLifecyclePending   DataRepositoryTaskLifecycle = "PENDING"
	DataRepositoryTaskLifecycleExecuting DataRepositoryTaskLifecycle = "EXECUTING"
	DataRepositoryTaskLifecycleFailed    DataRepositoryTaskLifecycle = "FAILED"
	DataRepositoryTaskLifecycleSucceeded DataRepositoryTaskLifecycle = "SUCCEEDED"
	DataRepositoryTaskLifecycleCanceled  DataRepositoryTaskLifecycle = "CANCELED"
	DataRepositoryTaskLifecycleCanceling DataRepositoryTaskLifecycle = "CANCELING"
)

func (enum DataRepositoryTaskLifecycle) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DataRepositoryTaskLifecycle) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type DataRepositoryTaskType string

// Enum values for DataRepositoryTaskType
const (
	DataRepositoryTaskTypeExportToRepository DataRepositoryTaskType = "EXPORT_TO_REPOSITORY"
)

func (enum DataRepositoryTaskType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum DataRepositoryTaskType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The lifecycle status of the file system.
type FileSystemLifecycle string

// Enum values for FileSystemLifecycle
const (
	FileSystemLifecycleAvailable     FileSystemLifecycle = "AVAILABLE"
	FileSystemLifecycleCreating      FileSystemLifecycle = "CREATING"
	FileSystemLifecycleFailed        FileSystemLifecycle = "FAILED"
	FileSystemLifecycleDeleting      FileSystemLifecycle = "DELETING"
	FileSystemLifecycleMisconfigured FileSystemLifecycle = "MISCONFIGURED"
	FileSystemLifecycleUpdating      FileSystemLifecycle = "UPDATING"
)

func (enum FileSystemLifecycle) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FileSystemLifecycle) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// An enumeration specifying the currently ongoing maintenance operation.
type FileSystemMaintenanceOperation string

// Enum values for FileSystemMaintenanceOperation
const (
	FileSystemMaintenanceOperationPatching  FileSystemMaintenanceOperation = "PATCHING"
	FileSystemMaintenanceOperationBackingUp FileSystemMaintenanceOperation = "BACKING_UP"
)

func (enum FileSystemMaintenanceOperation) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FileSystemMaintenanceOperation) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The type of file system.
type FileSystemType string

// Enum values for FileSystemType
const (
	FileSystemTypeWindows FileSystemType = "WINDOWS"
	FileSystemTypeLustre  FileSystemType = "LUSTRE"
)

func (enum FileSystemType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FileSystemType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The name for a filter.
type FilterName string

// Enum values for FilterName
const (
	FilterNameFileSystemId   FilterName = "file-system-id"
	FilterNameBackupType     FilterName = "backup-type"
	FilterNameFileSystemType FilterName = "file-system-type"
)

func (enum FilterName) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum FilterName) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type LustreDeploymentType string

// Enum values for LustreDeploymentType
const (
	LustreDeploymentTypeScratch1    LustreDeploymentType = "SCRATCH_1"
	LustreDeploymentTypeScratch2    LustreDeploymentType = "SCRATCH_2"
	LustreDeploymentTypePersistent1 LustreDeploymentType = "PERSISTENT_1"
)

func (enum LustreDeploymentType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum LustreDeploymentType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ReportFormat string

// Enum values for ReportFormat
const (
	ReportFormatReportCsv20191124 ReportFormat = "REPORT_CSV_20191124"
)

func (enum ReportFormat) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ReportFormat) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type ReportScope string

// Enum values for ReportScope
const (
	ReportScopeFailedFilesOnly ReportScope = "FAILED_FILES_ONLY"
)

func (enum ReportScope) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ReportScope) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The types of limits on your service utilization. Limits include file system
// count, total throughput capacity, total storage, and total user-initiated
// backups. These limits apply for a specific account in a specific AWS Region.
// You can increase some of them by contacting AWS Support.
type ServiceLimit string

// Enum values for ServiceLimit
const (
	ServiceLimitFileSystemCount           ServiceLimit = "FILE_SYSTEM_COUNT"
	ServiceLimitTotalThroughputCapacity   ServiceLimit = "TOTAL_THROUGHPUT_CAPACITY"
	ServiceLimitTotalStorage              ServiceLimit = "TOTAL_STORAGE"
	ServiceLimitTotalUserInitiatedBackups ServiceLimit = "TOTAL_USER_INITIATED_BACKUPS"
)

func (enum ServiceLimit) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum ServiceLimit) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type Status string

// Enum values for Status
const (
	StatusFailed            Status = "FAILED"
	StatusInProgress        Status = "IN_PROGRESS"
	StatusPending           Status = "PENDING"
	StatusCompleted         Status = "COMPLETED"
	StatusUpdatedOptimizing Status = "UPDATED_OPTIMIZING"
)

func (enum Status) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum Status) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

// The storage type for your Amazon FSx file system.
type StorageType string

// Enum values for StorageType
const (
	StorageTypeSsd StorageType = "SSD"
	StorageTypeHdd StorageType = "HDD"
)

func (enum StorageType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum StorageType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}

type WindowsDeploymentType string

// Enum values for WindowsDeploymentType
const (
	WindowsDeploymentTypeMultiAz1  WindowsDeploymentType = "MULTI_AZ_1"
	WindowsDeploymentTypeSingleAz1 WindowsDeploymentType = "SINGLE_AZ_1"
	WindowsDeploymentTypeSingleAz2 WindowsDeploymentType = "SINGLE_AZ_2"
)

func (enum WindowsDeploymentType) MarshalValue() (string, error) {
	return string(enum), nil
}

func (enum WindowsDeploymentType) MarshalValueBuf(b []byte) ([]byte, error) {
	b = b[0:0]
	return append(b, enum...), nil
}
