// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutEventTypeInput struct {
	_ struct{} `type:"structure"`

	// The description of the event type.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The entity type for the event type. Example entity types: customer, merchant,
	// account.
	//
	// EntityTypes is a required field
	EntityTypes []string `locationName:"entityTypes" min:"1" type:"list" required:"true"`

	// The event type variables.
	//
	// EventVariables is a required field
	EventVariables []string `locationName:"eventVariables" min:"1" type:"list" required:"true"`

	// The event type labels.
	Labels []string `locationName:"labels" type:"list"`

	// The name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A collection of key and value pairs.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s PutEventTypeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventTypeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutEventTypeInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.EntityTypes == nil {
		invalidParams.Add(aws.NewErrParamRequired("EntityTypes"))
	}
	if s.EntityTypes != nil && len(s.EntityTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EntityTypes", 1))
	}

	if s.EventVariables == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventVariables"))
	}
	if s.EventVariables != nil && len(s.EventVariables) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EventVariables", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutEventTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutEventTypeOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutEventType = "PutEventType"

// PutEventTypeRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Creates or updates an event type. An event is a business activity that is
// evaluated for fraud risk. With Amazon Fraud Detector, you generate fraud
// predictions for events. An event type defines the structure for an event
// sent to Amazon Fraud Detector. This includes the variables sent as part of
// the event, the entity performing the event (such as a customer), and the
// labels that classify the event. Example event types include online payment
// transactions, account registrations, and authentications.
//
//    // Example sending a request using PutEventTypeRequest.
//    req := client.PutEventTypeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType
func (c *Client) PutEventTypeRequest(input *PutEventTypeInput) PutEventTypeRequest {
	op := &aws.Operation{
		Name:       opPutEventType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventTypeInput{}
	}

	req := c.newRequest(op, input, &PutEventTypeOutput{})

	return PutEventTypeRequest{Request: req, Input: input, Copy: c.PutEventTypeRequest}
}

// PutEventTypeRequest is the request type for the
// PutEventType API operation.
type PutEventTypeRequest struct {
	*aws.Request
	Input *PutEventTypeInput
	Copy  func(*PutEventTypeInput) PutEventTypeRequest
}

// Send marshals and sends the PutEventType API request.
func (r PutEventTypeRequest) Send(ctx context.Context) (*PutEventTypeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutEventTypeResponse{
		PutEventTypeOutput: r.Request.Data.(*PutEventTypeOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutEventTypeResponse is the response type for the
// PutEventType API operation.
type PutEventTypeResponse struct {
	*PutEventTypeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutEventType request.
func (r *PutEventTypeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
