// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetPredictionInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" type:"string" required:"true"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" type:"string"`

	// Names of variables you defined in Amazon Fraud Detector to represent event
	// data elements and their corresponding values for the event you are sending
	// for evaluation.
	EventAttributes map[string]string `locationName:"eventAttributes" type:"map"`

	// The unique ID used to identify the event.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// The Amazon SageMaker model endpoint input data blobs.
	ExternalModelEndpointDataBlobs map[string]ModelEndpointDataBlob `locationName:"externalModelEndpointDataBlobs" type:"map" sensitive:"true"`
}

// String returns the string representation
func (s GetPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPredictionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPredictionInput"}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}

	if s.EventId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventId"))
	}
	if s.ExternalModelEndpointDataBlobs != nil {
		for i, v := range s.ExternalModelEndpointDataBlobs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExternalModelEndpointDataBlobs", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetPredictionOutput struct {
	_ struct{} `type:"structure"`

	// The model scores for models used in the detector version.
	ModelScores []ModelScores `locationName:"modelScores" type:"list"`

	// The prediction outcomes.
	Outcomes []string `locationName:"outcomes" type:"list"`

	// The rule results in the prediction.
	RuleResults []RuleResult `locationName:"ruleResults" type:"list"`
}

// String returns the string representation
func (s GetPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetPrediction = "GetPrediction"

// GetPredictionRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Evaluates an event against a detector version. If a version ID is not provided,
// the detector’s (ACTIVE) version is used.
//
//    // Example sending a request using GetPredictionRequest.
//    req := client.GetPredictionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetPrediction
func (c *Client) GetPredictionRequest(input *GetPredictionInput) GetPredictionRequest {
	op := &aws.Operation{
		Name:       opGetPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPredictionInput{}
	}

	req := c.newRequest(op, input, &GetPredictionOutput{})

	return GetPredictionRequest{Request: req, Input: input, Copy: c.GetPredictionRequest}
}

// GetPredictionRequest is the request type for the
// GetPrediction API operation.
type GetPredictionRequest struct {
	*aws.Request
	Input *GetPredictionInput
	Copy  func(*GetPredictionInput) GetPredictionRequest
}

// Send marshals and sends the GetPrediction API request.
func (r GetPredictionRequest) Send(ctx context.Context) (*GetPredictionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPredictionResponse{
		GetPredictionOutput: r.Request.Data.(*GetPredictionOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPredictionResponse is the response type for the
// GetPrediction API operation.
type GetPredictionResponse struct {
	*GetPredictionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPrediction request.
func (r *GetPredictionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
