// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// A rule.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRuleInput"}

	if s.Rule == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Deletes the rule. You cannot delete a rule if it is used by an ACTIVE or
// INACTIVE detector version.
//
//    // Example sending a request using DeleteRuleRequest.
//    req := client.DeleteRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule
func (c *Client) DeleteRuleRequest(input *DeleteRuleInput) DeleteRuleRequest {
	op := &aws.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	req := c.newRequest(op, input, &DeleteRuleOutput{})

	return DeleteRuleRequest{Request: req, Input: input, Copy: c.DeleteRuleRequest}
}

// DeleteRuleRequest is the request type for the
// DeleteRule API operation.
type DeleteRuleRequest struct {
	*aws.Request
	Input *DeleteRuleInput
	Copy  func(*DeleteRuleInput) DeleteRuleRequest
}

// Send marshals and sends the DeleteRule API request.
func (r DeleteRuleRequest) Send(ctx context.Context) (*DeleteRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRuleResponse{
		DeleteRuleOutput: r.Request.Data.(*DeleteRuleOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRuleResponse is the response type for the
// DeleteRule API operation.
type DeleteRuleResponse struct {
	*DeleteRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRule request.
func (r *DeleteRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
