// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyClusterInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The number of steps that can be executed concurrently. You can specify a
	// maximum of 256 steps.
	StepConcurrencyLevel *int64 `type:"integer"`
}

// String returns the string representation
func (s ModifyClusterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyClusterInput"}

	if s.ClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyClusterOutput struct {
	_ struct{} `type:"structure"`

	// The number of steps that can be executed concurrently.
	StepConcurrencyLevel *int64 `type:"integer"`
}

// String returns the string representation
func (s ModifyClusterOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyCluster = "ModifyCluster"

// ModifyClusterRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Modifies the number of steps that can be executed concurrently for the cluster
// specified using ClusterID.
//
//    // Example sending a request using ModifyClusterRequest.
//    req := client.ModifyClusterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ModifyCluster
func (c *Client) ModifyClusterRequest(input *ModifyClusterInput) ModifyClusterRequest {
	op := &aws.Operation{
		Name:       opModifyCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterInput{}
	}

	req := c.newRequest(op, input, &ModifyClusterOutput{})

	return ModifyClusterRequest{Request: req, Input: input, Copy: c.ModifyClusterRequest}
}

// ModifyClusterRequest is the request type for the
// ModifyCluster API operation.
type ModifyClusterRequest struct {
	*aws.Request
	Input *ModifyClusterInput
	Copy  func(*ModifyClusterInput) ModifyClusterRequest
}

// Send marshals and sends the ModifyCluster API request.
func (r ModifyClusterRequest) Send(ctx context.Context) (*ModifyClusterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyClusterResponse{
		ModifyClusterOutput: r.Request.Data.(*ModifyClusterOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyClusterResponse is the response type for the
// ModifyCluster API operation.
type ModifyClusterResponse struct {
	*ModifyClusterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyCluster request.
func (r *ModifyClusterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
