// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListInstanceFleetsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the cluster.
	//
	// ClusterId is a required field
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstanceFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstanceFleetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListInstanceFleetsInput"}

	if s.ClusterId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListInstanceFleetsOutput struct {
	_ struct{} `type:"structure"`

	// The list of instance fleets for the cluster and given filters.
	InstanceFleets []InstanceFleet `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListInstanceFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListInstanceFleets = "ListInstanceFleets"

// ListInstanceFleetsRequest returns a request value for making API operation for
// Amazon Elastic MapReduce.
//
// Lists all available details about the instance fleets in a cluster.
//
// The instance fleet configuration is available only in Amazon EMR versions
// 4.8.0 and later, excluding 5.0.x versions.
//
//    // Example sending a request using ListInstanceFleetsRequest.
//    req := client.ListInstanceFleetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/ListInstanceFleets
func (c *Client) ListInstanceFleetsRequest(input *ListInstanceFleetsInput) ListInstanceFleetsRequest {
	op := &aws.Operation{
		Name:       opListInstanceFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstanceFleetsInput{}
	}

	req := c.newRequest(op, input, &ListInstanceFleetsOutput{})

	return ListInstanceFleetsRequest{Request: req, Input: input, Copy: c.ListInstanceFleetsRequest}
}

// ListInstanceFleetsRequest is the request type for the
// ListInstanceFleets API operation.
type ListInstanceFleetsRequest struct {
	*aws.Request
	Input *ListInstanceFleetsInput
	Copy  func(*ListInstanceFleetsInput) ListInstanceFleetsRequest
}

// Send marshals and sends the ListInstanceFleets API request.
func (r ListInstanceFleetsRequest) Send(ctx context.Context) (*ListInstanceFleetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListInstanceFleetsResponse{
		ListInstanceFleetsOutput: r.Request.Data.(*ListInstanceFleetsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListInstanceFleetsRequestPaginator returns a paginator for ListInstanceFleets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListInstanceFleetsRequest(input)
//   p := emr.NewListInstanceFleetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListInstanceFleetsPaginator(req ListInstanceFleetsRequest) ListInstanceFleetsPaginator {
	return ListInstanceFleetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListInstanceFleetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListInstanceFleetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListInstanceFleetsPaginator struct {
	aws.Pager
}

func (p *ListInstanceFleetsPaginator) CurrentPage() *ListInstanceFleetsOutput {
	return p.Pager.CurrentPage().(*ListInstanceFleetsOutput)
}

// ListInstanceFleetsResponse is the response type for the
// ListInstanceFleets API operation.
type ListInstanceFleetsResponse struct {
	*ListInstanceFleetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListInstanceFleets request.
func (r *ListInstanceFleetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
