// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for request parameters to CreatePackage operation.
type CreatePackageInput struct {
	_ struct{} `type:"structure"`

	// Description of the package.
	PackageDescription *string `type:"string"`

	// Unique identifier for the package.
	//
	// PackageName is a required field
	PackageName *string `min:"3" type:"string" required:"true"`

	// The customer S3 location PackageSource for importing the package.
	//
	// PackageSource is a required field
	PackageSource *PackageSource `type:"structure" required:"true"`

	// Type of package. Currently supports only TXT-DICTIONARY.
	//
	// PackageType is a required field
	PackageType PackageType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreatePackageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePackageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreatePackageInput"}

	if s.PackageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("PackageName", 3))
	}

	if s.PackageSource == nil {
		invalidParams.Add(aws.NewErrParamRequired("PackageSource"))
	}
	if len(s.PackageType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("PackageType"))
	}
	if s.PackageSource != nil {
		if err := s.PackageSource.Validate(); err != nil {
			invalidParams.AddNested("PackageSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreatePackageInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.PackageDescription != nil {
		v := *s.PackageDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PackageDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageName != nil {
		v := *s.PackageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PackageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PackageSource != nil {
		v := s.PackageSource

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PackageSource", v, metadata)
	}
	if len(s.PackageType) > 0 {
		v := s.PackageType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PackageType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Container for response returned by CreatePackage operation.
type CreatePackageOutput struct {
	_ struct{} `type:"structure"`

	// Information about the package PackageDetails.
	PackageDetails *PackageDetails `type:"structure"`
}

// String returns the string representation
func (s CreatePackageOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreatePackageOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.PackageDetails != nil {
		v := s.PackageDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PackageDetails", v, metadata)
	}
	return nil
}

const opCreatePackage = "CreatePackage"

// CreatePackageRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Create a package for use with Amazon ES domains.
//
//    // Example sending a request using CreatePackageRequest.
//    req := client.CreatePackageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreatePackageRequest(input *CreatePackageInput) CreatePackageRequest {
	op := &aws.Operation{
		Name:       opCreatePackage,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/packages",
	}

	if input == nil {
		input = &CreatePackageInput{}
	}

	req := c.newRequest(op, input, &CreatePackageOutput{})

	return CreatePackageRequest{Request: req, Input: input, Copy: c.CreatePackageRequest}
}

// CreatePackageRequest is the request type for the
// CreatePackage API operation.
type CreatePackageRequest struct {
	*aws.Request
	Input *CreatePackageInput
	Copy  func(*CreatePackageInput) CreatePackageRequest
}

// Send marshals and sends the CreatePackage API request.
func (r CreatePackageRequest) Send(ctx context.Context) (*CreatePackageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreatePackageResponse{
		CreatePackageOutput: r.Request.Data.(*CreatePackageOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreatePackageResponse is the response type for the
// CreatePackage API operation.
type CreatePackageResponse struct {
	*CreatePackageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreatePackage request.
func (r *CreatePackageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
