// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type PutAttributesInput struct {
	_ struct{} `type:"structure"`

	// The attributes to apply to your resource. You can specify up to 10 custom
	// attributes per resource. You can specify up to 10 attributes in a single
	// call.
	//
	// Attributes is a required field
	Attributes []Attribute `locationName:"attributes" type:"list" required:"true"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that contains
	// the resource to apply attributes. If you do not specify a cluster, the default
	// cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`
}

// String returns the string representation
func (s PutAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutAttributesInput"}

	if s.Attributes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The attributes applied to your resource.
	Attributes []Attribute `locationName:"attributes" type:"list"`
}

// String returns the string representation
func (s PutAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutAttributes = "PutAttributes"

// PutAttributesRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Create or update an attribute on an Amazon ECS resource. If the attribute
// does not exist, it is created. If the attribute exists, its value is replaced
// with the specified value. To delete an attribute, use DeleteAttributes. For
// more information, see Attributes (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes)
// in the Amazon Elastic Container Service Developer Guide.
//
//    // Example sending a request using PutAttributesRequest.
//    req := client.PutAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/PutAttributes
func (c *Client) PutAttributesRequest(input *PutAttributesInput) PutAttributesRequest {
	op := &aws.Operation{
		Name:       opPutAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAttributesInput{}
	}

	req := c.newRequest(op, input, &PutAttributesOutput{})

	return PutAttributesRequest{Request: req, Input: input, Copy: c.PutAttributesRequest}
}

// PutAttributesRequest is the request type for the
// PutAttributes API operation.
type PutAttributesRequest struct {
	*aws.Request
	Input *PutAttributesInput
	Copy  func(*PutAttributesInput) PutAttributesRequest
}

// Send marshals and sends the PutAttributes API request.
func (r PutAttributesRequest) Send(ctx context.Context) (*PutAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutAttributesResponse{
		PutAttributesOutput: r.Request.Data.(*PutAttributesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutAttributesResponse is the response type for the
// PutAttributes API operation.
type PutAttributesResponse struct {
	*PutAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutAttributes request.
func (r *PutAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
