// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateCapacityProviderInput struct {
	_ struct{} `type:"structure"`

	// The details of the Auto Scaling group for the capacity provider.
	//
	// AutoScalingGroupProvider is a required field
	AutoScalingGroupProvider *AutoScalingGroupProvider `locationName:"autoScalingGroupProvider" type:"structure" required:"true"`

	// The name of the capacity provider. Up to 255 characters are allowed, including
	// letters (upper and lowercase), numbers, underscores, and hyphens. The name
	// cannot be prefixed with "aws", "ecs", or "fargate".
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The metadata that you apply to the capacity provider to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both
	// of which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for AWS use. You
	//    cannot edit or delete tag keys or values with this prefix. Tags with this
	//    prefix do not count against your tags per resource limit.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s CreateCapacityProviderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCapacityProviderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCapacityProviderInput"}

	if s.AutoScalingGroupProvider == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupProvider"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.AutoScalingGroupProvider != nil {
		if err := s.AutoScalingGroupProvider.Validate(); err != nil {
			invalidParams.AddNested("AutoScalingGroupProvider", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateCapacityProviderOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the new capacity provider.
	CapacityProvider *CapacityProvider `locationName:"capacityProvider" type:"structure"`
}

// String returns the string representation
func (s CreateCapacityProviderOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateCapacityProvider = "CreateCapacityProvider"

// CreateCapacityProviderRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Creates a new capacity provider. Capacity providers are associated with an
// Amazon ECS cluster and are used in capacity provider strategies to facilitate
// cluster auto scaling.
//
// Only capacity providers using an Auto Scaling group can be created. Amazon
// ECS tasks on AWS Fargate use the FARGATE and FARGATE_SPOT capacity providers
// which are already created and available to all accounts in Regions supported
// by AWS Fargate.
//
//    // Example sending a request using CreateCapacityProviderRequest.
//    req := client.CreateCapacityProviderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/CreateCapacityProvider
func (c *Client) CreateCapacityProviderRequest(input *CreateCapacityProviderInput) CreateCapacityProviderRequest {
	op := &aws.Operation{
		Name:       opCreateCapacityProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCapacityProviderInput{}
	}

	req := c.newRequest(op, input, &CreateCapacityProviderOutput{})

	return CreateCapacityProviderRequest{Request: req, Input: input, Copy: c.CreateCapacityProviderRequest}
}

// CreateCapacityProviderRequest is the request type for the
// CreateCapacityProvider API operation.
type CreateCapacityProviderRequest struct {
	*aws.Request
	Input *CreateCapacityProviderInput
	Copy  func(*CreateCapacityProviderInput) CreateCapacityProviderRequest
}

// Send marshals and sends the CreateCapacityProvider API request.
func (r CreateCapacityProviderRequest) Send(ctx context.Context) (*CreateCapacityProviderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCapacityProviderResponse{
		CreateCapacityProviderOutput: r.Request.Data.(*CreateCapacityProviderOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCapacityProviderResponse is the response type for the
// CreateCapacityProvider API operation.
type CreateCapacityProviderResponse struct {
	*CreateCapacityProviderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCapacityProvider request.
func (r *CreateCapacityProviderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
